/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizer;
import net.shibboleth.idp.authn.SubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public abstract class AbstractNameIDCanonicalizer
extends NameIDCanonicalizationFlowDescriptor
implements SubjectCanonicalizer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSubjectCanonicalizer.class);
    @NonnullAfterInit
    private String logPrefix;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = "SubjectCanonicalizer " + this.ensureId() + ":";
    }

    @Nullable
    public String apply(@Nullable SubjectCanonicalizationContext c14nContext) {
        this.checkComponentActive();
        if (c14nContext == null) {
            return "InvalidSubjectCanonicalizationContext";
        }
        if (c14nContext.getSubject() == null) {
            this.log.error("{} No Subject found in context", (Object)this.getLogPrefix());
            return "InvalidSubjectCanonicalizationContext";
        }
        return this.doApply(c14nContext);
    }

    @Nullable
    protected abstract String doApply(@Nonnull SubjectCanonicalizationContext var1);

    @NonnullAfterInit
    protected String getLogPrefix() {
        return this.logPrefix;
    }
}

