/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;

public class RevocationCacheCondition
extends AbstractInitializableComponent
implements BiPredicate<ProfileRequestContext, AuthenticationResult> {
    @Nonnull
    @NotEmpty
    public static final String REVOCATION_CONTEXT = "LoginFlowRevocation";
    @Nonnull
    @NotEmpty
    public static final String PRINCIPAL_REVOCATION_PREFIX = "prin!";
    @Nonnull
    @NotEmpty
    public static final String ADDRESS_REVOCATION_PREFIX = "addr!";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RevocationCacheCondition.class);
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        this.checkSetterPreconditions();
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setPrincipalNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.principalNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Principal name lookup strategy cannot be null");
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> supplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = supplier;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
        if (this.principalNameLookupStrategy == null) {
            throw new ComponentInitializationException("Principal name lookup strategy cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input, @Nullable AuthenticationResult input2) {
        this.checkComponentActive();
        if (input == null || input2 == null) {
            this.log.error("Called with null inputs");
            return true;
        }
        String principal = this.principalNameLookupStrategy.apply(input);
        if (principal == null) {
            this.log.error("Principal lookup strategy returned null value");
            return true;
        }
        this.log.debug("Checking revocation for principal name {} for {} result", (Object)principal, (Object)input2.getAuthenticationFlowId());
        ScratchContext context = (ScratchContext)input.ensureSubcontext(ScratchContext.class);
        if (!context.getMap().containsKey(this.getClass())) {
            try {
                String principalRecord = this.revocationCache.getRevocationRecord(REVOCATION_CONTEXT, PRINCIPAL_REVOCATION_PREFIX + principal);
                HttpServletRequest request = this.httpServletRequestSupplier != null ? (HttpServletRequest)this.httpServletRequestSupplier.get() : null;
                String addressRecord = request != null ? this.revocationCache.getRevocationRecord(REVOCATION_CONTEXT, ADDRESS_REVOCATION_PREFIX + request.getRemoteAddr()) : null;
                ArrayList<String> records = new ArrayList<String>(2);
                if (principalRecord != null) {
                    records.add(principalRecord);
                }
                if (addressRecord != null) {
                    records.add(addressRecord);
                }
                context.getMap().put(this.getClass(), records);
            }
            catch (IOException e) {
                this.log.error("Error checking revocation cache for principal {}, treating as revoked", (Object)principal, (Object)e);
                return true;
            }
        }
        return this.isRevoked(principal, input2, (Collection)context.getMap().get(this.getClass()));
    }

    protected boolean isRevoked(@Nonnull @NotEmpty String principal, @Nonnull AuthenticationResult result, @Nonnull Collection<String> revocationRecords) {
        for (String r : revocationRecords) {
            if (!result.getAuthenticationInstant().isBefore(Instant.ofEpochSecond(Long.valueOf(r)))) continue;
            this.log.info("Authentication result {} for principal {} has been revoked", (Object)result.getAuthenticationFlowId(), (Object)principal);
            return true;
        }
        return false;
    }
}

