/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.logic.Constraint;

public class InexactPrincipalEvalPredicateFactory
implements PrincipalEvalPredicateFactory {
    @Nonnull
    private final HashMultimap<String, String> matchingRules;

    InexactPrincipalEvalPredicateFactory() {
        HashMultimap hm = HashMultimap.create();
        assert (hm != null);
        this.matchingRules = hm;
    }

    @Nonnull
    @Live
    Multimap<String, String> getMatchingRules() {
        return this.matchingRules;
    }

    public void setMatchingRules(@Nonnull Map<String, Collection<String>> rules) {
        Constraint.isNotNull(rules, (String)"Map cannot be null");
        this.matchingRules.clear();
        for (Map.Entry<String, Collection<String>> e : rules.entrySet()) {
            if (Strings.isNullOrEmpty((String)e.getKey()) || e.getValue() == null) continue;
            this.matchingRules.putAll((Object)e.getKey(), List.copyOf(e.getValue()));
        }
    }

    @Nonnull
    public PrincipalEvalPredicate getPredicate(@Nonnull Principal candidate) {
        return new InexactMatchPredicate(candidate);
    }

    private class InexactMatchPredicate
    implements PrincipalEvalPredicate {
        @Nonnull
        private final Principal principal;
        @Nullable
        private Principal theMatch;

        public InexactMatchPredicate(Principal candidate) {
            this.principal = (Principal)Constraint.isNotNull((Object)candidate, (String)"Principal cannot be null");
        }

        public boolean test(PrincipalSupportingComponent input) {
            assert (input != null);
            Set matches = InexactPrincipalEvalPredicateFactory.this.matchingRules.get((Object)this.principal.getName());
            Set inputs = input.getSupportedPrincipals(this.principal.getClass());
            for (Principal p : inputs) {
                if (!matches.contains(p.getName())) continue;
                this.theMatch = p;
                return true;
            }
            return false;
        }

        @Nullable
        public Principal getMatchingPrincipal() {
            return this.theMatch;
        }
    }
}

