/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.shared.logic.Constraint;

public class ExactPrincipalEvalPredicateFactory
implements PrincipalEvalPredicateFactory {
    @Nonnull
    public PrincipalEvalPredicate getPredicate(@Nonnull Principal candidate) {
        return new ExactMatchPredicate(candidate);
    }

    private class ExactMatchPredicate
    implements PrincipalEvalPredicate {
        @Nonnull
        private final Principal principal;

        public ExactMatchPredicate(Principal candidate) {
            this.principal = (Principal)Constraint.isNotNull((Object)candidate, (String)"Principal cannot be null");
        }

        public boolean test(@Nullable PrincipalSupportingComponent input) {
            return input != null && input.getSupportedPrincipals(this.principal.getClass()).contains(this.principal);
        }

        @Nullable
        public Principal getMatchingPrincipal() {
            return this.principal;
        }
    }
}

