/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.CertificateContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;

public class ValidateExternalAuthentication
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.external";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateExternalAuthentication.class);
    @Nullable
    private ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private Pattern matchExpression;
    @NonnullBeforeExec
    private ExternalAuthenticationContext extContext;
    @Nullable
    private AttributeContext attributeContext;

    public ValidateExternalAuthentication() {
        this(null);
    }

    public ValidateExternalAuthentication(@Nullable ReloadableService<AttributeFilter> filterService) {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.attributeFilterService = filterService;
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        this.checkSetterPreconditions();
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.checkSetterPreconditions();
        this.metadataResolver = resolver;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.extContext = (ExternalAuthenticationContext)authenticationContext.getSubcontext(ExternalAuthenticationContext.class);
        if (this.extContext == null) {
            this.log.debug("{} No ExternalAuthenticationContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String authnEvent = this.extContext.getAuthnEvent();
        Exception authnExp = this.extContext.getAuthnException();
        String principalName = this.extContext.getPrincipalName();
        if (authnEvent != null) {
            this.log.info("{} External authentication produced event: {}", new Object[]{this.getLogPrefix(), authnEvent, this.extContext.getAuthnException()});
            if (authnExp != null) {
                this.handleError(profileRequestContext, authenticationContext, authnExp, authnEvent);
            } else {
                this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnError(), authnEvent);
            }
            this.recordFailure(profileRequestContext);
            return;
        }
        if (authnExp != null) {
            this.log.info("{} External authentication produced exception", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnException());
            this.handleError(profileRequestContext, authenticationContext, authnExp, "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.extContext.getAuthnError() != null) {
            this.log.info("{} External authentication produced error message: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnError());
            this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnError(), "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.extContext.getSubject() != null) {
            this.log.info("{} External authentication succeeded for Subject", (Object)this.getLogPrefix());
        } else if (this.extContext.getPrincipal() != null) {
            this.log.info("{} External authentication succeeded for Principal: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getPrincipal());
            Principal p = this.extContext.getPrincipal();
            assert (p != null);
            this.extContext.setSubject(new Subject(false, CollectionSupport.singleton((Object)p), CollectionSupport.emptySet(), CollectionSupport.emptySet()));
        } else if (principalName != null) {
            this.log.info("{} External authentication succeeded for user: {}", (Object)this.getLogPrefix(), (Object)principalName);
            this.extContext.setSubject(new Subject(false, CollectionSupport.singleton((Object)new UsernamePrincipal(principalName)), CollectionSupport.emptySet(), CollectionSupport.emptySet()));
        } else {
            this.log.info("{} External authentication failed, no user identity or error information returned", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return;
        }
        Subject subject = this.extContext.getSubject();
        assert (subject != null);
        if (!this.checkUsername(subject)) {
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
            return;
        }
        this.recordSuccess(profileRequestContext);
        if (!this.extContext.getAuthenticatingAuthorities().isEmpty()) {
            ProxyAuthenticationPrincipal proxied = new ProxyAuthenticationPrincipal(this.extContext.getAuthenticatingAuthorities());
            subject.getPrincipals().add((Principal)proxied);
        }
        if (this.extContext.doNotCache()) {
            this.log.debug("{} Disabling caching of authentication result", (Object)this.getLogPrefix());
            authenticationContext.setResultCacheable(false);
        }
        assert (this.extContext != null);
        this.filterAttributes(this.extContext);
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        AuthenticationResult result = authenticationContext.getAuthenticationResult();
        assert (result != null);
        Instant ai = this.extContext.getAuthnInstant();
        if (ai != null) {
            result.setAuthenticationInstant(ai);
        }
        result.setResultLifetime(this.extContext.getAuthnLifetime());
        result.setResultTimeout(this.extContext.getAuthnTimeout());
        if (this.extContext.isPreviousResult()) {
            result.setPreviousResult(true);
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        assert (this.isPreExecuteCalled());
        Subject localSubject = (Subject)Constraint.isNotNull((Object)this.extContext.getSubject(), (String)"external Authn Subject cannot be null");
        localSubject.getPrincipals().addAll(subject.getPrincipals());
        AttributeContext ac = this.attributeContext;
        if (ac != null && !ac.getIdPAttributes().isEmpty()) {
            this.log.debug("{} Adding filtered inbound attributes to Subject", (Object)this.getLogPrefix());
            localSubject.getPrincipals().addAll((Collection)((NonnullSupplier)ac.getIdPAttributes().values().stream().map(a -> {
                assert (a != null);
                return new IdPAttributePrincipal(a);
            }).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get());
        }
        return localSubject;
    }

    private boolean checkUsername(@Nonnull Subject subject) {
        if (this.matchExpression != null) {
            String name = this.getUsername(subject);
            if (name != null) {
                assert (this.matchExpression != null);
                if (this.matchExpression.matcher(name).matches()) {
                    return true;
                }
                this.log.info("{} Username {} did not match expression", (Object)this.getLogPrefix(), (Object)name);
                return false;
            }
            this.log.info("{} Match expression set, but no UsernamePrincipal found");
            return false;
        }
        return true;
    }

    @Nullable
    private String getUsername(@Nonnull Subject subject) {
        Set<UsernamePrincipal> princs = subject.getPrincipals(UsernamePrincipal.class);
        if (princs != null && !princs.isEmpty()) {
            return princs.iterator().next().getName();
        }
        return null;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        String name;
        Subject subject = this.extContext != null ? this.extContext.getSubject() : null;
        if (subject != null && (name = this.getUsername(subject)) != null) {
            return CollectionSupport.singletonMap((Object)"u", (Object)name);
        }
        return super.getAuditFields(profileRequestContext);
    }

    private void filterAttributes(@Nonnull ExternalAuthenticationContext localExtContext) {
        AttributeContext ac = (AttributeContext)localExtContext.getSubcontext(AttributeContext.class);
        if (ac == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return;
        }
        this.attributeContext = ac;
        if (ac.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return;
        }
        if (this.attributeFilterService == null) {
            this.log.warn("{} No AttributeFilter service provided, clearing inbound attributes", (Object)this.getLogPrefix());
            ac.setIdPAttributes((Map)null);
            return;
        }
        AttributeFilterContext filterContext = (AttributeFilterContext)localExtContext.ensureSubcontext(AttributeFilterContext.class);
        this.populateFilterContext(filterContext);
        assert (this.attributeFilterService != null);
        try (ServiceableComponent component = this.attributeFilterService.getServiceableComponent();){
            AttributeFilter filter = (AttributeFilter)component.getComponent();
            filter.filterAttributes(filterContext);
            filterContext.removeFromParent();
            ac.setIdPAttributes(filterContext.getFilteredIdPAttributes());
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error while filtering inbound attributes", (Object)this.getLogPrefix(), (Object)e);
            ac.setIdPAttributes((Map)null);
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid AttributeFilter configuration", (Object)this.getLogPrefix(), (Object)e);
            ac.setIdPAttributes((Map)null);
        }
    }

    private void populateFilterContext(@Nonnull AttributeFilterContext filterContext) {
        AttributeContext ac = this.attributeContext;
        ExternalAuthenticationContext ec = this.extContext;
        assert (ac != null && ec != null);
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(ac.getIdPAttributes()).setMetadataResolver(this.metadataResolver).setRequesterMetadataContextLookupStrategy(null).setProxiedRequesterContextLookupStrategy(null);
        if (!ec.getAuthenticatingAuthorities().isEmpty()) {
            filterContext.setAttributeIssuerID((String)ec.getAuthenticatingAuthorities().iterator().next());
        }
    }

    public static class CertificateCleanupHook
    implements Consumer<ProfileRequestContext> {
        @Override
        public void accept(@Nullable ProfileRequestContext input) {
            CertificateContext cc;
            AuthenticationContext authnCtx;
            if (input != null && (authnCtx = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null && (cc = (CertificateContext)authnCtx.getSubcontext(CertificateContext.class)) != null) {
                authnCtx.removeSubcontext((BaseContext)cc);
            }
        }
    }
}

