/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class RelyingPartyMapJAASLoginConfigStrategy
extends AbstractRelyingPartyLookupFunction<Collection<Pair<String, Subject>>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RelyingPartyMapJAASLoginConfigStrategy.class);
    @Nonnull
    private Map<String, String> relyingPartyMap;
    @Nonnull
    private String defaultConfigName;

    public RelyingPartyMapJAASLoginConfigStrategy(@Nonnull @ParameterName(name="map") Map<String, String> map) {
        this.relyingPartyMap = (Map)Constraint.isNotNull(map, (String)"Relying party map was null");
        this.defaultConfigName = "ShibUserPassAuth";
    }

    public void setDefaultConfigName(@Nonnull @NotEmpty String name) {
        this.defaultConfigName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Default config name was null or empty");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<Pair<String, Subject>> apply(@Nullable ProfileRequestContext profileRequestContext) {
        RelyingPartyContext relyingPartyContext = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(profileRequestContext);
        if (relyingPartyContext == null) {
            this.log.warn("No RelyingPartyContext was available, using default config name");
            return CollectionSupport.singleton((Object)new Pair((Object)this.defaultConfigName, (Object)null));
        }
        String relyingPartyId = relyingPartyContext.getRelyingPartyId();
        if (relyingPartyId == null) {
            this.log.warn("No relying party ID was available, using default config name");
            return CollectionSupport.singleton((Object)new Pair((Object)this.defaultConfigName, (Object)null));
        }
        String config = StringSupport.trimOrNull((String)this.relyingPartyMap.get(relyingPartyId));
        if (config != null) {
            this.log.debug("For relying party ID '{}' resolved JAAS config name '{}'", (Object)relyingPartyId, (Object)config);
            return CollectionSupport.singleton((Object)new Pair((Object)config, (Object)null));
        }
        this.log.debug("For relying party ID '{}' resolved no JAAS config name, returning default", (Object)relyingPartyId);
        return CollectionSupport.singleton((Object)new Pair((Object)this.defaultConfigName, (Object)null));
    }
}

