/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateMultiFactorAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateMultiFactorAuthenticationContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MultiFactorAuthenticationTransition>> transitionMapLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, MultiFactorAuthenticationContext> multiFactorContextCreationStrategy = new ChildContextLookup(MultiFactorAuthenticationContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private Function<ProfileRequestContext, Collection<AuthenticationResult>> activeResultLookupStrategy = new DefaultResultLookupStrategy();

    PopulateMultiFactorAuthenticationContext() {
    }

    public void setTransitionMapLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MultiFactorAuthenticationTransition>> strategy) {
        this.checkSetterPreconditions();
        this.transitionMapLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Transition map lookup strategy cannot be null");
    }

    public void setMultiFactorContextCreationStrategy(@Nonnull Function<ProfileRequestContext, MultiFactorAuthenticationContext> strategy) {
        this.checkSetterPreconditions();
        this.multiFactorContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"MultiFactorAuthenticationContext creation strategy cannot be null");
    }

    public void setActiveResultLookupStrategy(@Nullable Function<ProfileRequestContext, Collection<AuthenticationResult>> strategy) {
        this.checkSetterPreconditions();
        this.activeResultLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Map<String, MultiFactorAuthenticationTransition> transitionMap = this.transitionMapLookupStrategy.apply(profileRequestContext);
        if (transitionMap == null) {
            this.log.info("No map of transition rules was returned");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"ReselectFlow");
            return;
        }
        MultiFactorAuthenticationContext mfaCtx = this.multiFactorContextCreationStrategy.apply(profileRequestContext);
        if (mfaCtx == null) {
            this.log.error("{} Unable to create/access MultiFactorAuthenticationContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        mfaCtx.setAuthenticationFlowDescriptor(authenticationContext.getAttemptedFlow());
        mfaCtx.setTransitionMap(transitionMap);
        mfaCtx.setNextFlowId(null);
        mfaCtx.getActiveResults().clear();
        if (this.activeResultLookupStrategy != null) {
            Collection<AuthenticationResult> results = this.activeResultLookupStrategy.apply(profileRequestContext);
            if (results != null) {
                for (AuthenticationResult result : results) {
                    mfaCtx.getActiveResults().put(result.getAuthenticationFlowId(), result);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("{} {} active result(s) extracted for possible reuse: {}", new Object[]{this.getLogPrefix(), results.size(), mfaCtx.getActiveResults().keySet()});
                }
            } else {
                this.log.debug("{} No active results extracted", (Object)this.getLogPrefix());
            }
        } else {
            this.log.debug("{} No lookup strategy provided, no active results will be made available", (Object)this.getLogPrefix());
        }
    }

    private final class DefaultResultLookupStrategy
    implements Function<ProfileRequestContext, Collection<AuthenticationResult>> {
        private DefaultResultLookupStrategy() {
        }

        @Override
        @Nullable
        public Collection<AuthenticationResult> apply(@Nullable ProfileRequestContext input) {
            AuthenticationContext ac;
            AuthenticationFlowDescriptor acf;
            if (input != null && (acf = (ac = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) != null ? ac.getAttemptedFlow() : null) != null) {
                assert (ac != null);
                AuthenticationResult mfaResult = (AuthenticationResult)ac.getActiveResults().get(acf.ensureId());
                if (mfaResult != null) {
                    if (ac.isForceAuthn()) {
                        PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result due to forced authentication requirement", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix());
                        return null;
                    }
                    Set<AuthenticationResultPrincipal> resultPrincipals = mfaResult.getSubject().getPrincipals(AuthenticationResultPrincipal.class);
                    if (!resultPrincipals.isEmpty()) {
                        ArrayList<AuthenticationResult> results = new ArrayList<AuthenticationResult>(resultPrincipals.size());
                        for (AuthenticationResultPrincipal resultPrincipal : resultPrincipals) {
                            resultPrincipal.getAuthenticationResult().setLastActivityInstant(mfaResult.getLastActivityInstant());
                            this.processActiveResult(input, ac, results, resultPrincipal.getAuthenticationResult());
                        }
                        return results;
                    }
                }
            }
            return null;
        }

        void processActiveResult(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Collection<AuthenticationResult> results, @Nonnull AuthenticationResult candidate) {
            AuthenticationFlowDescriptor descriptor = (AuthenticationFlowDescriptor)authenticationContext.getAvailableFlows().get(candidate.getAuthenticationFlowId());
            if (descriptor != null) {
                if (descriptor.test(profileRequestContext)) {
                    if (descriptor.isResultActive(candidate)) {
                        BiPredicate revocationCondition = descriptor.getRevocationCondition();
                        if (authenticationContext.getMaxAge() != null && candidate.getAuthenticationInstant().plus(authenticationContext.getMaxAge()).isBefore(Instant.now())) {
                            PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result from login flow {} due to maxAge on request", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
                        } else if (revocationCondition != null && revocationCondition.test(profileRequestContext, candidate)) {
                            PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active but revoked result from login flow {}", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
                        } else {
                            results.add(candidate);
                        }
                    } else {
                        PopulateMultiFactorAuthenticationContext.this.log.debug("{} Result from login flow {} has expired", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)descriptor.getId());
                    }
                } else {
                    PopulateMultiFactorAuthenticationContext.this.log.debug("{} Ignoring active result from login flow {} due to activation condition", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
                }
            } else {
                PopulateMultiFactorAuthenticationContext.this.log.warn("{} Ignoring active result from undefined login flow {}", (Object)PopulateMultiFactorAuthenticationContext.this.getLogPrefix(), (Object)candidate.getAuthenticationFlowId());
            }
        }
    }
}

