/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectCanonicalizationContextSubjectLookupFunction;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SubjectDerivedAttributesFunction
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<IdPAttribute>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubjectDerivedAttributesFunction.class);
    private boolean forCanonicalization;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @Nullable
    private Function<ProfileRequestContext, Subject> subjectLookupStrategy;

    public boolean isForCanonicalization() {
        return this.forCanonicalization;
    }

    public void setForCanonicalization(boolean flag) {
        this.checkSetterPreconditions();
        this.forCanonicalization = flag;
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setSubjectLookupStrategy(@Nullable Function<ProfileRequestContext, Subject> strategy) {
        this.checkSetterPreconditions();
        this.subjectLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.forCanonicalization && this.subjectLookupStrategy == null) {
            this.log.debug("{} Marked for use during canonicalication, auto-installing Subject lookup strategy", (Object)this.getLogPrefix());
            this.subjectLookupStrategy = new SubjectCanonicalizationContextSubjectLookupFunction().compose((Function)new ChildContextLookup(SubjectCanonicalizationContext.class));
        }
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<IdPAttribute> apply(@Nullable ProfileRequestContext prc) {
        List subjects = CollectionSupport.emptyList();
        if (this.subjectLookupStrategy != null) {
            Subject subject = this.subjectLookupStrategy.apply(prc);
            if (subject == null) {
                this.log.debug("{} No Subject returned from lookup, no attribute resolved", (Object)this.getLogPrefix());
                return null;
            }
            subjects = CollectionSupport.singletonList((Object)subject);
        } else {
            SubjectContext cs = this.scLookupStrategy.apply(prc);
            if (cs == null || cs.getSubjects().isEmpty()) {
                this.log.debug("{} No Subjects returned from SubjectContext lookup, no attribute resolved", (Object)this.getLogPrefix());
                return null;
            }
            subjects = cs.getSubjects();
        }
        ArrayList<IdPAttribute> results = new ArrayList<IdPAttribute>();
        for (Subject subject : subjects) {
            results.addAll(subject.getPrincipals(IdPAttributePrincipal.class).stream().map(IdPAttributePrincipal::getAttribute).collect(Collectors.toUnmodifiableList()));
        }
        if (results.isEmpty()) {
            this.log.info("{} No attributes resolved", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} attributes", (Object)this.getLogPrefix(), (Object)results.size());
        return results;
    }

    private String getLogPrefix() {
        return "SubjectDerivedDataConnector " + this.getId();
    }
}

