/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.AbstractMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ResultMappingStrategy;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class StringResultMappingStrategy
extends AbstractMappingStrategy<ResultSet>
implements ResultMappingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringResultMappingStrategy.class);

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> map(@Nonnull ResultSet results) throws ResolutionException {
        Constraint.isNotNull((Object)results, (String)"Result set can not be null");
        try {
            if (!results.next()) {
                this.log.debug("Result set did not contain any rows, nothing to map");
                if (this.isNoResultAnError()) {
                    throw new NoResultAnErrorResolutionException("No rows returned from query");
                }
                return null;
            }
            ResultSetMetaData resultMetadata = results.getMetaData();
            HashMap<String, IdPAttribute> attributes = new HashMap<String, IdPAttribute>(resultMetadata.getColumnCount());
            Map<String, String> aliases = this.getResultRenamingMap();
            int rowCount = 0;
            do {
                if (++rowCount > 1 && this.isMultipleResultsAnError()) {
                    throw new MultipleResultAnErrorResolutionException("Multiple rows returned from query");
                }
                for (int i = 1; i <= resultMetadata.getColumnCount(); ++i) {
                    IdPAttribute attribute;
                    String effectiveId;
                    String originalId = resultMetadata.getColumnName(i);
                    String string = effectiveId = aliases.containsKey(originalId) ? aliases.get(originalId) : originalId;
                    assert (effectiveId != null);
                    if (this.log.isDebugEnabled() && !effectiveId.equals(originalId)) {
                        this.log.debug("Remapping column {} to {}", (Object)originalId, (Object)effectiveId);
                    }
                    if ((attribute = (IdPAttribute)attributes.get(effectiveId)) == null) {
                        attribute = new IdPAttribute(effectiveId);
                        attributes.put(effectiveId, attribute);
                    }
                    if (attribute.getValues().isEmpty()) {
                        attribute.setValues(CollectionSupport.singletonList((Object)StringAttributeValue.valueOf((String)results.getString(i))));
                        continue;
                    }
                    ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>(attribute.getValues());
                    values.add(StringAttributeValue.valueOf((String)results.getString(i)));
                    attribute.setValues(values);
                }
            } while (results.next());
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        catch (SQLException e) {
            throw new ResolutionException("Error reading data from result set", e);
        }
    }
}

