/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ExecutableStatement;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;

public abstract class AbstractExecutableStatementBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<ExecutableStatement> {
    @Nonnull
    private Duration queryTimeout;

    public AbstractExecutableStatementBuilder() {
        Duration fiveSecs = Duration.ofSeconds(5L);
        assert (fiveSecs != null);
        this.queryTimeout = fiveSecs;
    }

    @Nonnull
    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(@Nonnull Duration timeout) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)timeout, (String)"Query timeout cannot be null");
        Constraint.isFalse((boolean)timeout.isNegative(), (String)"Query timeout cannot be negative");
        this.queryTimeout = timeout;
    }

    @Nonnull
    protected abstract String getSQLQuery(@Nonnull AttributeResolutionContext var1, @Nonnull Map<String, List<IdPAttributeValue>> var2) throws ResolutionException;

    @Override
    @Nonnull
    public ExecutableStatement build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        final String query = this.getSQLQuery(resolutionContext, dependencyAttributes);
        return new ExecutableStatement(){

            @Override
            @Nullable
            public String getResultCacheKey() {
                return query;
            }

            @Override
            @Nonnull
            public ResultSet execute(@Nonnull Connection connection) throws SQLException {
                Statement stmt = connection.createStatement();
                stmt.setQueryTimeout((int)AbstractExecutableStatementBuilder.this.queryTimeout.toSeconds());
                ResultSet resultSet = stmt.executeQuery(query);
                assert (resultSet != null);
                return resultSet;
            }

            public String toString() {
                return query;
            }
        };
    }
}

