/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ldap.AbstractExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.ExecutableSearchFilter;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.ldaptive.FilterTemplate;
import org.slf4j.Logger;

public class TemplatedExecutableSearchFilterBuilder
extends AbstractExecutableSearchFilterBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedExecutableSearchFilterBuilder.class);
    @NonnullAfterInit
    private Template template;
    @NonnullAfterInit
    private String templateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    private ReferenceInsertionEventHandler eventHandler = new EscapingReferenceInsertionEventHandler();
    private boolean v2Compatibility;

    @NonnullAfterInit
    public Template getTemplate() {
        return this.template;
    }

    @NonnullAfterInit
    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(@Nullable String velocityTemplate) {
        this.checkSetterPreconditions();
        this.templateText = StringSupport.trimOrNull((String)velocityTemplate);
    }

    @Nullable
    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.checkSetterPreconditions();
        this.engine = velocityEngine;
    }

    @Nullable
    public ReferenceInsertionEventHandler getReferenceInsertionEventHandler() {
        return this.eventHandler;
    }

    public void setReferenceInsertionEventHandler(@Nullable ReferenceInsertionEventHandler handler) {
        this.checkSetterPreconditions();
        this.eventHandler = handler;
    }

    public boolean isV2Compatibility() {
        return this.v2Compatibility;
    }

    public void setV2Compatibility(boolean compat) {
        this.v2Compatibility = compat;
    }

    protected void addExtraVelocityContext(@Nonnull VelocityContext velocityContext, @Nonnull AttributeResolutionContext resolutionContext) {
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        VelocityEngine localEngine = this.engine;
        String localTemplateText = this.templateText;
        if (null == localEngine) {
            throw new ComponentInitializationException("TemplatedExecutableStatementBuilder: no velocity engine was configured");
        }
        if (null == localTemplateText) {
            throw new ComponentInitializationException("TemplatedExecutableStatementBuilder: template text must be non null");
        }
        this.template = Template.fromTemplate((VelocityEngine)localEngine, (String)localTemplateText);
    }

    @Override
    @Nonnull
    public ExecutableSearchFilter build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating search filter using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        this.addExtraVelocityContext(context, resolutionContext);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        if (this.eventHandler != null) {
            EventCartridge cartridge = new EventCartridge();
            cartridge.addEventHandler((EventHandler)this.eventHandler);
            cartridge.attachToContext((Context)context);
        }
        try {
            FilterTemplate searchFilter = new FilterTemplate(this.merge(context));
            return super.build(searchFilter);
        }
        catch (VelocityException e) {
            this.log.error("Error running template: {}", (Object)e.getMessage());
            throw new ResolutionException("Error running template", (Exception)((Object)e));
        }
    }

    @Nonnull
    protected String merge(@Nonnull VelocityContext context) {
        String result = this.template.merge((Context)context).trim();
        this.log.debug("Template text {} yields {}", (Object)this.templateText, (Object)result);
        assert (result != null);
        return result;
    }

    protected static class EscapingReferenceInsertionEventHandler
    implements ReferenceInsertionEventHandler {
        protected EscapingReferenceInsertionEventHandler() {
        }

        public Object referenceInsert(Context context, String reference, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Object[]) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Object[])value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues.toArray();
            }
            if (value instanceof Collection) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Collection)value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues;
            }
            return this.encode(value);
        }

        private Object encode(Object value) {
            if (value instanceof String) {
                return FilterTemplate.encodeValue((String)((String)value));
            }
            if (value instanceof byte[]) {
                return FilterTemplate.encodeValue((byte[])((byte[])value));
            }
            return value;
        }
    }
}

