/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public final class ResolvedDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final DataConnector resolvedConnector;
    @Nullable
    private final Map<String, IdPAttribute> resolvedAttributes;

    public ResolvedDataConnector(@Nonnull DataConnector connector, @Nullable Map<String, IdPAttribute> attributes) {
        this.resolvedConnector = (DataConnector)Constraint.isNotNull((Object)connector, (String)"Resolved data connector cannot be null");
        this.resolvedAttributes = attributes;
        Constraint.isTrue((boolean)connector.isInitialized(), (String)"Provided connector should be initialized");
        Constraint.isFalse((boolean)connector.isDestroyed(), (String)"Provided connector must not be destroyed");
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        return this.resolvedAttributes;
    }

    @Override
    public boolean equals(Object obj) {
        return this.resolvedConnector.equals(obj);
    }

    @Override
    @Nonnull
    public Set<ResolverAttributeDefinitionDependency> getAttributeDependencies() {
        return this.resolvedConnector.getAttributeDependencies();
    }

    @Override
    @Nonnull
    public Set<ResolverDataConnectorDependency> getDataConnectorDependencies() {
        return this.resolvedConnector.getDataConnectorDependencies();
    }

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return null;
    }

    @Override
    @Nullable
    public String getFailoverDataConnectorId() {
        return null;
    }

    @Nonnull
    public String getId() {
        String id = this.resolvedConnector.getId();
        assert (id != null);
        return id;
    }

    @Override
    public int hashCode() {
        return this.resolvedConnector.hashCode();
    }

    @Override
    public boolean isPropagateResolutionExceptions() {
        return this.resolvedConnector.isPropagateResolutionExceptions();
    }

    @Override
    public void setFailoverDataConnectorId(@Nullable String id) {
    }

    @Override
    public void setPropagateResolutionExceptions(boolean propagate) {
    }

    @Nonnull
    public String toString() {
        String result = this.resolvedConnector.toString();
        assert (result != null);
        return result;
    }

    @Override
    public void setExportAttributes(@Nonnull Collection<String> what) {
        this.checkSetterPreconditions();
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getExportAttributes() {
        return this.resolvedConnector.getExportAttributes();
    }

    @Nullable
    public Map<String, IdPAttribute> getResolvedAttributes() {
        return this.resolvedAttributes;
    }

    @Nonnull
    public DataConnector getResolvedConnector() {
        return this.resolvedConnector;
    }

    public boolean isInitialized() {
        return true;
    }
}

