/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AttributeType;
import org.ldaptive.schema.DITContentRule;
import org.ldaptive.schema.DITStructureRule;
import org.ldaptive.schema.MatchingRule;
import org.ldaptive.schema.MatchingRuleUse;
import org.ldaptive.schema.NameForm;
import org.ldaptive.schema.ObjectClass;
import org.ldaptive.schema.SchemaElementRegistry;
import org.ldaptive.schema.Syntax;

public final class Schema
extends AbstractFreezable {
    private static final int HASH_CODE_SEED = 1181;
    private static final String BINARY_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.5";
    private final SchemaElementRegistry<String, AttributeType> attributeTypes = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, DITContentRule> ditContentRules = new SchemaElementRegistry();
    private final SchemaElementRegistry<Integer, DITStructureRule> ditStructureRules = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, Syntax> syntaxes = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, MatchingRule> matchingRules = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, MatchingRuleUse> matchingRuleUses = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, NameForm> nameForms = new SchemaElementRegistry();
    private final SchemaElementRegistry<String, ObjectClass> objectClasses = new SchemaElementRegistry();

    public Schema() {
    }

    public Schema(Collection<AttributeType> attributeTypes, Collection<DITContentRule> ditContentRules, Collection<DITStructureRule> ditStructureRules, Collection<Syntax> syntaxes, Collection<MatchingRule> matchingRules, Collection<MatchingRuleUse> matchingRuleUses, Collection<NameForm> nameForms, Collection<ObjectClass> objectClasses) {
        this.setAttributeTypes(attributeTypes);
        this.setDITContentRules(ditContentRules);
        this.setDITStructureRules(ditStructureRules);
        this.setSyntaxes(syntaxes);
        this.setMatchingRules(matchingRules);
        this.setMatchingRuleUses(matchingRuleUses);
        this.setNameForms(nameForms);
        this.setObjectClasses(objectClasses);
    }

    @Override
    public void freeze() {
        super.freeze();
        this.attributeTypes.freeze();
        this.ditContentRules.freeze();
        this.ditStructureRules.freeze();
        this.syntaxes.freeze();
        this.matchingRules.freeze();
        this.matchingRuleUses.freeze();
        this.nameForms.freeze();
        this.objectClasses.freeze();
    }

    public Collection<AttributeType> getAttributeTypes() {
        return this.attributeTypes.getElements();
    }

    public AttributeType getAttributeType(String name) {
        AttributeType attributeType = this.attributeTypes.getElementByKey(name);
        if (attributeType == null) {
            return this.attributeTypes.getElementByName(name);
        }
        return attributeType;
    }

    public void setAttributeTypes(Collection<AttributeType> c) {
        this.assertMutable();
        this.attributeTypes.setElements(c);
    }

    public String[] getBinaryAttributeNames() {
        ArrayList binaryAttrs = new ArrayList();
        for (AttributeType type : this.attributeTypes.getElements()) {
            boolean isBinary = false;
            String syntaxOid = type.getSyntaxOID(false);
            if (BINARY_SYNTAX.equals(syntaxOid)) {
                isBinary = true;
            } else {
                Syntax syntax = this.getSyntax(syntaxOid);
                if (Syntax.containsBooleanExtension(syntax, "X-NOT-HUMAN-READABLE")) {
                    isBinary = true;
                }
            }
            if (!isBinary) continue;
            Collections.addAll(binaryAttrs, type.getNames());
        }
        return binaryAttrs.toArray(new String[0]);
    }

    public Collection<DITContentRule> getDITContentRules() {
        return this.ditContentRules.getElements();
    }

    public DITContentRule getDITContentRule(String name) {
        DITContentRule ditContentRule = this.ditContentRules.getElementByKey(name);
        if (ditContentRule == null) {
            return this.ditContentRules.getElementByName(name);
        }
        return ditContentRule;
    }

    public void setDITContentRules(Collection<DITContentRule> c) {
        this.assertMutable();
        this.ditContentRules.setElements(c);
    }

    public Collection<DITStructureRule> getDITStructureRules() {
        return this.ditStructureRules.getElements();
    }

    public DITStructureRule getDITStructureRule(int id) {
        return this.ditStructureRules.getElementByKey(id);
    }

    public DITStructureRule getDITStructureRule(String name) {
        return this.ditStructureRules.getElementByName(name);
    }

    public void setDITStructureRules(Collection<DITStructureRule> c) {
        this.assertMutable();
        this.ditStructureRules.setElements(c);
    }

    public Collection<Syntax> getSyntaxes() {
        return this.syntaxes.getElements();
    }

    public Syntax getSyntax(String oid) {
        return this.syntaxes.getElementByKey(oid);
    }

    public void setSyntaxes(Collection<Syntax> c) {
        this.assertMutable();
        this.syntaxes.setElements(c);
    }

    public Collection<MatchingRule> getMatchingRules() {
        return this.matchingRules.getElements();
    }

    public MatchingRule getMatchingRule(String name) {
        MatchingRule matchingRule = this.matchingRules.getElementByKey(name);
        if (matchingRule == null) {
            return this.matchingRules.getElementByName(name);
        }
        return matchingRule;
    }

    public void setMatchingRules(Collection<MatchingRule> c) {
        this.assertMutable();
        this.matchingRules.setElements(c);
    }

    public Collection<MatchingRuleUse> getMatchingRuleUses() {
        return this.matchingRuleUses.getElements();
    }

    public MatchingRuleUse getMatchingRuleUse(String name) {
        MatchingRuleUse matchingRuleUse = this.matchingRuleUses.getElementByKey(name);
        if (matchingRuleUse == null) {
            return this.matchingRuleUses.getElementByName(name);
        }
        return matchingRuleUse;
    }

    public void setMatchingRuleUses(Collection<MatchingRuleUse> c) {
        this.assertMutable();
        this.matchingRuleUses.setElements(c);
    }

    public Collection<NameForm> getNameForms() {
        return this.nameForms.getElements();
    }

    public NameForm getNameForm(String name) {
        NameForm nameForm = this.nameForms.getElementByKey(name);
        if (nameForm == null) {
            return this.nameForms.getElementByName(name);
        }
        return nameForm;
    }

    public void setNameForms(Collection<NameForm> c) {
        this.assertMutable();
        this.nameForms.setElements(c);
    }

    public Collection<ObjectClass> getObjectClasses() {
        return this.objectClasses.getElements();
    }

    public ObjectClass getObjectClass(String name) {
        ObjectClass objectClass = this.objectClasses.getElementByKey(name);
        if (objectClass == null) {
            return this.objectClasses.getElementByName(name);
        }
        return objectClass;
    }

    public void setObjectClasses(Collection<ObjectClass> c) {
        this.assertMutable();
        this.objectClasses.setElements(c);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Schema) {
            Schema v = (Schema)o;
            return LdapUtils.areEqual(this.attributeTypes, v.attributeTypes) && LdapUtils.areEqual(this.ditContentRules, v.ditContentRules) && LdapUtils.areEqual(this.ditStructureRules, v.ditStructureRules) && LdapUtils.areEqual(this.syntaxes, v.syntaxes) && LdapUtils.areEqual(this.matchingRules, v.matchingRules) && LdapUtils.areEqual(this.matchingRuleUses, v.matchingRuleUses) && LdapUtils.areEqual(this.nameForms, v.nameForms) && LdapUtils.areEqual(this.objectClasses, v.objectClasses);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(1181, this.attributeTypes, this.ditContentRules, this.ditStructureRules, this.syntaxes, this.matchingRules, this.matchingRuleUses, this.nameForms, this.objectClasses);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::attributeTypes=" + String.valueOf(this.attributeTypes) + ", ditContentRules=" + String.valueOf(this.ditContentRules) + ", ditStructureRules=" + String.valueOf(this.ditStructureRules) + ", syntaxes=" + String.valueOf(this.syntaxes) + ", matchingRules=" + String.valueOf(this.matchingRules) + ", matchingRuleUses=" + String.valueOf(this.matchingRuleUses) + ", nameForms=" + String.valueOf(this.nameForms) + ", objectClasses=" + String.valueOf(this.objectClasses) + "]";
    }
}

