/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ldaptive.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableWorker<T> {
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final int MAX_QUEUE_SIZE = 65535;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService;
    private final Duration timeout;

    public CallableWorker(String poolName) {
        this(poolName, DEFAULT_NUM_THREADS, Duration.ZERO);
    }

    public CallableWorker(String poolName, Duration time) {
        this(poolName, DEFAULT_NUM_THREADS, time);
    }

    public CallableWorker(String poolName, int numThreads) {
        this(poolName, numThreads, Duration.ZERO);
    }

    public CallableWorker(String poolName, int numThreads, Duration time) {
        this.timeout = LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Timeout cannot be null or negative");
        this.executorService = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(65535), r -> {
            Thread t = new Thread(r, "ldaptive-" + poolName + "@" + this.hashCode());
            t.setDaemon(true);
            return t;
        }, new ThreadPoolExecutor.AbortPolicy());
    }

    public CallableWorker(ExecutorService es) {
        this(es, Duration.ZERO);
    }

    public CallableWorker(ExecutorService es, Duration time) {
        this.timeout = LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Timeout cannot be null or negative");
        this.executorService = LdapUtils.assertNotNullArg(es, "Executor service cannot be null");
    }

    public List<ExecutionException> execute(Callable<T> callable, int count, Consumer<T> consumer) {
        return this.execute(IntStream.range(0, count).mapToObj(i -> callable).collect(Collectors.toList()), consumer);
    }

    public List<ExecutionException> execute(List<Callable<T>> callables, Consumer<T> consumer) {
        ExecutorCompletionService cs = new ExecutorCompletionService(this.executorService);
        ArrayList futures = new ArrayList(callables.size());
        callables.forEach(c -> futures.add(cs.submit(c)));
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>(callables.size());
        for (Future f : futures) {
            try {
                Object result = Duration.ZERO.equals(this.timeout) ? f.get() : f.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                consumer.accept(result);
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
            catch (TimeoutException e) {
                f.cancel(false);
                exceptions.add(new ExecutionException(e));
            }
            catch (InterruptedException e) {
                this.logger.warn("Concurrent execution interrupted", (Throwable)e);
                exceptions.add(new ExecutionException(e));
            }
        }
        return exceptions;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

