/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth.ext;

import java.time.Clock;
import java.time.Period;
import java.time.ZonedDateTime;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.ad.transcode.FileTimeValueTranscoder;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.ext.ActiveDirectoryAccountState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDirectoryAuthenticationResponseHandler
extends AbstractFreezable
implements AuthenticationResponseHandler {
    public static final String[] ATTRIBUTES = new String[]{"msDS-UserPasswordExpiryTimeComputed", "pwdLastSet"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Clock expirationClock;
    private Period expirationPeriod;
    private Period warningPeriod;

    ActiveDirectoryAuthenticationResponseHandler(Clock clock) {
        this.expirationClock = clock;
    }

    public ActiveDirectoryAuthenticationResponseHandler() {
        this.expirationClock = Clock.systemDefaultZone();
    }

    public ActiveDirectoryAuthenticationResponseHandler(Period warning) {
        this.expirationClock = Clock.systemDefaultZone();
        this.setWarningPeriod(warning);
    }

    public ActiveDirectoryAuthenticationResponseHandler(Period expiration, Period warning) {
        this.expirationClock = Clock.systemDefaultZone();
        this.setExpirationPeriod(expiration);
        this.setWarningPeriod(warning);
    }

    @Override
    public void handle(AuthenticationResponse response) {
        if (response.isSuccess()) {
            LdapEntry entry = response.getLdapEntry();
            LdapAttribute expTime = entry != null ? entry.getAttribute("msDS-UserPasswordExpiryTimeComputed") : null;
            LdapAttribute pwdLastSet = entry != null ? entry.getAttribute("pwdLastSet") : null;
            this.logger.debug("Read attributes msDS-UserPasswordExpiryTimeComputed: {}, pwdLastSet: {}", (Object)expTime, (Object)pwdLastSet);
            ZonedDateTime exp = null;
            if (expTime != null && !"9223372036854775807".equals(expTime.getStringValue())) {
                exp = (ZonedDateTime)expTime.getValue(new FileTimeValueTranscoder().decoder());
            } else if (this.expirationPeriod != null && pwdLastSet != null) {
                exp = ((ZonedDateTime)pwdLastSet.getValue(new FileTimeValueTranscoder().decoder())).plus(this.expirationPeriod);
            }
            if (exp != null) {
                this.logger.debug("Transcoded passwordExpirationTime to {}", exp);
                if (this.warningPeriod != null) {
                    ZonedDateTime warn = exp.minus(this.warningPeriod);
                    ZonedDateTime now = ZonedDateTime.now(this.expirationClock);
                    this.logger.debug("Warning period is: {}, current datetime is {}", (Object)warn, (Object)now);
                    if (now.isAfter(warn)) {
                        response.setAccountState(new ActiveDirectoryAccountState(exp));
                    }
                } else {
                    this.logger.debug("No warning period is defined");
                    response.setAccountState(new ActiveDirectoryAccountState(exp));
                }
            }
        } else if (response.getDiagnosticMessage() != null) {
            this.logger.debug("Parsing response diagnostic message: {}", (Object)response.getDiagnosticMessage());
            ActiveDirectoryAccountState.Error adError = ActiveDirectoryAccountState.Error.parse(response.getDiagnosticMessage());
            if (adError != null) {
                this.logger.debug("Translated response diagnostic message to: {}", (Object)adError);
                response.setAccountState(new ActiveDirectoryAccountState(adError));
            }
        }
        this.logger.debug("Configured authentication response: {}", (Object)response);
    }

    public Period getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public void setExpirationPeriod(Period period) {
        this.assertMutable();
        this.expirationPeriod = period;
    }

    public Period getWarningPeriod() {
        return this.warningPeriod;
    }

    public void setWarningPeriod(Period period) {
        this.assertMutable();
        this.warningPeriod = period;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::expirationPeriod=" + String.valueOf(this.expirationPeriod) + ", warningPeriod=" + String.valueOf(this.warningPeriod) + "]";
    }
}

