/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.Credential;
import org.ldaptive.LdapUtils;
import org.ldaptive.auth.AuthenticationRequest;

public class AuthenticationCriteria {
    private String authenticationDn;
    private AuthenticationRequest authenticationRequest;

    public AuthenticationCriteria() {
    }

    public AuthenticationCriteria(String dn) {
        this.setDn(dn);
    }

    public AuthenticationCriteria(String dn, AuthenticationRequest request) {
        this.setDn(dn);
        this.setAuthenticationRequest(request);
    }

    public String getDn() {
        return this.authenticationDn;
    }

    public void setDn(String dn) {
        this.authenticationDn = LdapUtils.assertNotNullArg(dn, "DN cannot be null");
    }

    public Credential getCredential() {
        return this.authenticationRequest.getCredential();
    }

    public AuthenticationRequest getAuthenticationRequest() {
        return this.authenticationRequest;
    }

    public void setAuthenticationRequest(AuthenticationRequest request) {
        this.authenticationRequest = LdapUtils.assertNotNullArg(request, "Authentication request cannot be null");
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::dn=" + this.authenticationDn + ", authenticationRequest=" + String.valueOf(this.authenticationRequest) + "]";
    }
}

