/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregateAuthenticationResponseHandler
extends AbstractFreezable
implements AuthenticationResponseHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, AuthenticationResponseHandler[]> responseHandlers = new HashMap<String, AuthenticationResponseHandler[]>();

    public AggregateAuthenticationResponseHandler() {
    }

    public AggregateAuthenticationResponseHandler(Map<String, AuthenticationResponseHandler[]> handlers) {
        this.responseHandlers.putAll(handlers);
    }

    @Override
    public void freeze() {
        super.freeze();
        for (Object[] objectArray : this.responseHandlers.values()) {
            AggregateAuthenticationResponseHandler.freeze(objectArray);
        }
    }

    public Map<String, AuthenticationResponseHandler[]> getAuthenticationResponseHandlers() {
        return Collections.unmodifiableMap(this.responseHandlers);
    }

    public void setAuthenticationResponseHandlers(Map<String, AuthenticationResponseHandler[]> handlers) {
        this.assertMutable();
        this.logger.trace("setting authenticationResponseHandlers: {}", handlers);
        this.responseHandlers.putAll(handlers);
    }

    public void addAuthenticationResponseHandlers(String label, AuthenticationResponseHandler ... handlers) {
        this.assertMutable();
        this.logger.trace("adding authenticationResponseHandlers: {}:{}", (Object)label, (Object)Arrays.toString(handlers));
        this.responseHandlers.put(label, handlers);
    }

    @Override
    public void handle(AuthenticationResponse response) throws LdapException {
        String[] labeledDn = response.getResolvedDn().split(":", 2);
        AuthenticationResponseHandler[] handlers = this.responseHandlers.get(labeledDn[0]);
        if (handlers == null) {
            throw new LdapException(ResultCode.PARAM_ERROR, "Could not find response handlers for label: " + labeledDn[0]);
        }
        if (handlers.length > 0) {
            for (AuthenticationResponseHandler ah : handlers) {
                ah.handle(response);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final AggregateAuthenticationResponseHandler object = new AggregateAuthenticationResponseHandler();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder handler(String label, AuthenticationResponseHandler ... handlers) {
            this.object.addAuthenticationResponseHandlers(label, handlers);
            return this;
        }

        public AggregateAuthenticationResponseHandler build() {
            return this.object;
        }
    }
}

