/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.transport.ThreadPoolConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.TransportFactory;

public final class SingleConnectionFactory
extends DefaultConnectionFactory {
    private ConnectionProxy proxy;
    private boolean initialized;
    private boolean failFastInitialize = true;
    private boolean nonBlockingInitialize;
    private Predicate<Connection> onOpen;
    private Predicate<Connection> onClose;
    private ConnectionValidator validator;
    private ExecutorService factoryExecutor;

    public SingleConnectionFactory() {
        super(TransportFactory.getTransport(ThreadPoolConfig.singleIoThread("single", ThreadPoolConfig.ShutdownStrategy.CONNECTION_FACTORY_CLOSE)));
    }

    public SingleConnectionFactory(Transport t) {
        super(t);
    }

    public SingleConnectionFactory(String ldapUrl) {
        super(ldapUrl, TransportFactory.getTransport(ThreadPoolConfig.singleIoThread("single", ThreadPoolConfig.ShutdownStrategy.CONNECTION_FACTORY_CLOSE)));
    }

    public SingleConnectionFactory(String ldapUrl, Transport t) {
        super(ldapUrl, t);
    }

    public SingleConnectionFactory(ConnectionConfig cc) {
        super(cc, TransportFactory.getTransport(ThreadPoolConfig.singleIoThread("single", ThreadPoolConfig.ShutdownStrategy.CONNECTION_FACTORY_CLOSE)));
    }

    public SingleConnectionFactory(ConnectionConfig cc, Transport t) {
        super(cc, t);
    }

    @Override
    public void freeze() {
        super.freeze();
        SingleConnectionFactory.freeze(this.validator);
    }

    public boolean getFailFastInitialize() {
        return this.failFastInitialize;
    }

    public void setFailFastInitialize(boolean b) {
        this.assertMutable();
        this.failFastInitialize = b;
    }

    public boolean getNonBlockingInitialize() {
        return this.nonBlockingInitialize;
    }

    public void setNonBlockingInitialize(boolean b) {
        this.assertMutable();
        this.nonBlockingInitialize = b;
    }

    public Predicate<Connection> getOnOpen() {
        return this.onOpen;
    }

    public void setOnOpen(Predicate<Connection> function) {
        this.assertMutable();
        this.onOpen = function;
    }

    public Predicate<Connection> getOnClose() {
        return this.onClose;
    }

    public void setOnClose(Predicate<Connection> function) {
        this.assertMutable();
        this.onClose = function;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ConnectionValidator cv) {
        this.assertMutable();
        this.validator = cv;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void initialize() throws LdapException {
        if (this.initialized) {
            throw new IllegalStateException("Connection factory is already initialized for " + String.valueOf(this));
        }
        if (this.nonBlockingInitialize) {
            if (this.factoryExecutor == null) {
                this.factoryExecutor = this.validator != null ? Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "ldaptive-single-connection-factory");
                    t.setDaemon(true);
                    return t;
                }) : Executors.newCachedThreadPool(r -> {
                    Thread t = new Thread(r, "ldaptive-single-connection-factory");
                    t.setDaemon(true);
                    return t;
                });
            }
            this.factoryExecutor.execute(() -> {
                try {
                    this.initializeInternal();
                    this.logger.info("Initialize successful for {}", (Object)this);
                }
                catch (LdapException e) {
                    this.logger.debug("Initialize failed for {}", (Object)this, (Object)e);
                }
            });
        } else {
            if (this.validator != null) {
                this.factoryExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "ldaptive-single-connection-factory");
                    t.setDaemon(true);
                    return t;
                });
            }
            this.initializeInternal();
            this.logger.info("Initialize successful for {}", (Object)this);
        }
    }

    private synchronized void initializeInternal() throws LdapException {
        LdapException initializeEx = null;
        try {
            this.initializeConnectionProxy();
            this.logger.trace("factory initialized {}", (Object)this);
        }
        catch (LdapException e) {
            initializeEx = e;
            this.logger.warn("Could not initialize connection factory for {}", (Object)this, (Object)e);
        }
        if (this.validator != null) {
            ((ScheduledExecutorService)this.factoryExecutor).scheduleAtFixedRate(() -> {
                this.logger.debug("Begin validate task for {}", (Object)this);
                try {
                    this.validator.apply(this.proxy != null ? this.proxy.getConnection() : null);
                }
                catch (Exception e) {
                    this.logger.debug("Validation task failed for {}", (Object)this, (Object)e);
                }
                this.logger.debug("End validate task for {}", (Object)this);
            }, this.validator.getValidatePeriod().toMillis(), this.validator.getValidatePeriod().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (initializeEx != null && this.failFastInitialize) {
            throw initializeEx;
        }
        this.freeze();
    }

    private synchronized void initializeConnectionProxy() throws LdapException {
        Connection connection = super.getConnection();
        connection.open();
        this.proxy = new ConnectionProxy(connection);
        this.initialized = true;
        if (this.onOpen != null && !this.onOpen.test(this.proxy.getConnection())) {
            connection.close();
            this.proxy = null;
            this.initialized = false;
            throw new LdapException("On open function failed for " + String.valueOf(this));
        }
    }

    private synchronized void destroyConnectionProxy() {
        if (this.proxy != null) {
            if (this.onClose != null && !this.onClose.test(this.proxy.getConnection())) {
                this.logger.warn("On close function {} failed for {}", this.onClose, (Object)this);
            }
            this.proxy.getConnection().close();
        }
        this.proxy = null;
        this.initialized = false;
    }

    @Override
    public Connection getConnection() {
        if (!this.initialized) {
            throw new IllegalStateException("Connection factory is not initialized");
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)this.proxy);
    }

    @Override
    public synchronized void close() {
        this.destroyConnectionProxy();
        super.close();
        if (this.factoryExecutor != null) {
            try {
                this.factoryExecutor.shutdown();
            }
            finally {
                this.factoryExecutor = null;
            }
        }
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::transport=" + String.valueOf(this.getTransport()) + ", connection=" + String.valueOf(this.proxy != null ? this.proxy.getConnection() : null) + ", failFastInitialize=" + this.failFastInitialize + ", nonBlockingInitialize=" + this.nonBlockingInitialize + ", onOpen=" + String.valueOf(this.onOpen) + ", onClose=" + String.valueOf(this.onClose) + ", validator=" + String.valueOf(this.validator) + ", initialized=" + this.initialized + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Transport t) {
        return new Builder(t);
    }

    protected static class ConnectionProxy
    implements InvocationHandler {
        private static final int HASH_CODE_SEED = 509;
        private final Connection conn;

        public ConnectionProxy(Connection c) {
            this.conn = c;
        }

        public Connection getConnection() {
            return this.conn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConnectionProxy) {
                ConnectionProxy v = (ConnectionProxy)o;
                return LdapUtils.areEqual(this.conn, v.conn);
            }
            return false;
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(509, this.conn);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retValue = null;
            if (!"open".equals(method.getName()) && !"close".equals(method.getName())) {
                try {
                    retValue = method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return retValue;
        }
    }

    public static class Builder
    extends DefaultConnectionFactory.Builder {
        private final SingleConnectionFactory object;

        protected Builder() {
            this.object = new SingleConnectionFactory();
        }

        protected Builder(Transport transport) {
            this.object = new SingleConnectionFactory(transport);
        }

        @Override
        public Builder config(ConnectionConfig config) {
            this.object.setConnectionConfig(config);
            return this;
        }

        public Builder onOpen(Predicate<Connection> function) {
            this.object.setOnOpen(function);
            return this;
        }

        public Builder onClose(Predicate<Connection> function) {
            this.object.setOnClose(function);
            return this;
        }

        public Builder validator(ConnectionValidator validator) {
            this.object.setValidator(validator);
            return this;
        }

        public Builder failFastInitialize(boolean failFast) {
            this.object.setFailFastInitialize(failFast);
            return this;
        }

        public Builder nonBlockingInitialize(boolean nonBlocking) {
            this.object.setNonBlockingInitialize(nonBlocking);
            return this;
        }

        @Override
        public SingleConnectionFactory build() {
            return this.object;
        }
    }

    public class ReinitializeConnectionConsumer
    implements Consumer<Connection> {
        @Override
        public void accept(Connection conn) {
            if (SingleConnectionFactory.this.proxy != null && !SingleConnectionFactory.this.proxy.getConnection().equals(conn)) {
                throw new IllegalArgumentException("Connection not managed by this factory: " + String.valueOf(conn));
            }
            try {
                SingleConnectionFactory.this.destroyConnectionProxy();
                SingleConnectionFactory.this.initializeConnectionProxy();
            }
            catch (Exception e) {
                SingleConnectionFactory.this.logger.error("Could not reinitialize the connection proxy", (Throwable)e);
            }
        }
    }
}

