/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.LdapUtils;
import org.ldaptive.Message;
import org.ldaptive.ResultCode;

public interface Result
extends Message {
    public ResultCode getResultCode();

    public String getMatchedDN();

    public String getDiagnosticMessage();

    public String[] getReferralURLs();

    default public boolean isSuccess() {
        return ResultCode.SUCCESS == this.getResultCode();
    }

    default public String getEncodedDiagnosticMessage() {
        String msg = this.getDiagnosticMessage();
        if (msg != null && !msg.isEmpty()) {
            return LdapUtils.percentEncodeControlChars(msg);
        }
        return msg;
    }
}

