/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.ldaptive.AbstractConnectionStrategy;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapURLRetryMetadata;
import org.ldaptive.LdapURLSet;
import org.ldaptive.LdapUtils;

public abstract class AbstractPassiveConnectionStrategy
extends AbstractConnectionStrategy {
    @Override
    public void populate(String urls, LdapURLSet urlSet) {
        LdapUtils.assertNotNullArgOr(urls, String::isEmpty, "Urls cannot be null or empty");
        if (urls.contains(" ")) {
            String[] urlArray = urls.split(" ");
            urlSet.populate(IntStream.range(0, urlArray.length).mapToObj(i -> {
                LdapURL url = new LdapURL(urlArray[i]);
                url.setRetryMetadata(new LdapURLRetryMetadata(this));
                url.setPriority(i);
                return url;
            }).collect(Collectors.toList()));
        } else {
            LdapURL url = new LdapURL(urls);
            url.setRetryMetadata(new LdapURLRetryMetadata(this));
            urlSet.populate(Collections.singletonList(url));
        }
    }
}

