/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.impl;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.impl.AttributeFilterImpl;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import net.shibboleth.shared.spring.service.impl.SpringServiceableComponent;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;

public class AttributeFilterServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements NonnullFunction<ApplicationContext, ServiceableComponent<AttributeFilter>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeFilterServiceStrategy.class);

    @Nonnull
    public ServiceableComponent<AttributeFilter> apply(@Nullable ApplicationContext appContext) {
        if (appContext == null) {
            throw new ServiceException("ApplicationContext was null");
        }
        Collection afps = appContext.getBeansOfType(AttributeFilterPolicy.class).values();
        this.log.debug("Creating Attribute Filter {} with  {} Policies", (Object)this.getId(), (Object)afps.size());
        AttributeFilterImpl filter = new AttributeFilterImpl(this.ensureId(), afps);
        try {
            filter.initialize();
            SpringServiceableComponent result = new SpringServiceableComponent((Object)filter);
            result.setApplicationContext(appContext);
            result.setId(this.ensureId());
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute filter for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
    }
}

