/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring.basic.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.filter.matcher.impl.ScriptedMatcher;
import net.shibboleth.idp.attribute.filter.policyrule.impl.ScriptedPolicyRule;
import net.shibboleth.idp.attribute.filter.spring.BaseFilterParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.factory.EvaluableScriptFactoryBean;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptedMatcherParser
extends BaseFilterParser {
    @Nonnull
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:afp", "Script");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "Script");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedMatcherParser.class);

    @Nullable
    protected Class<?> getBeanClass(@Nonnull Element element) {
        if (this.isPolicyRule(element)) {
            return ScriptedPolicyRule.class;
        }
        return ScriptedMatcher.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        builder.addAutowiredProperty("scriptContextExtenders");
        String myId = this.resolveId(config, builder.getBeanDefinition(), parserContext);
        String logPrefix = "Scipted Filter '" + myId + "' :";
        BeanDefinitionBuilder scriptBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvaluableScriptFactoryBean.class);
        scriptBuilder.addPropertyValue("sourceId", (Object)logPrefix);
        if (config.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)config.getAttributeNS(null, "language"));
            this.log.debug("{} scripting language: {}.", (Object)logPrefix, (Object)scriptLanguage);
            scriptBuilder.addPropertyValue("engineName", (Object)scriptLanguage);
        }
        List scriptElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME);
        List scriptFileElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME);
        if (scriptElem != null && scriptElem.size() > 0) {
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                this.log.info("Attribute definition {}: definition contains both <Script> and <ScriptFile> elements, taking the <Script> element", (Object)logPrefix);
            }
            String script = ((Element)scriptElem.get(0)).getTextContent();
            this.log.debug("{} script {}.", (Object)logPrefix, (Object)script);
            scriptBuilder.addPropertyValue("script", (Object)script);
        } else if (scriptFileElem != null && scriptFileElem.size() > 0) {
            String scriptFile = ((Element)scriptFileElem.get(0)).getTextContent();
            this.log.debug("{} script file {}.", (Object)logPrefix, (Object)scriptFile);
            scriptBuilder.addPropertyValue("resource", (Object)scriptFile);
        } else {
            this.log.error("{} No script specified for this attribute definition");
            throw new BeanCreationException("No script specified for this attribute definition");
        }
        String customRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "customObjectRef"));
        if (null != customRef) {
            builder.addPropertyReference("customObject", customRef);
        }
        builder.addPropertyValue("id", (Object)myId);
        builder.addPropertyValue("script", (Object)scriptBuilder.getBeanDefinition());
    }
}

