/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.support;

import jakarta.servlet.ServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;

public class ProfileRequestContextFlowExecutionListener
implements FlowExecutionListener {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProfileRequestContextFlowExecutionListener.class);

    public void stateEntered(RequestContext context, StateDefinition previousState, StateDefinition newState) {
        if (previousState != null && previousState.getId().startsWith("Initialize")) {
            assert (context != null);
            ProfileRequestContext prc = this.getProfileRequestContext(context);
            ServletRequest request = this.getRequest(context);
            if (prc != null && request != null) {
                this.log.trace("Exposing ProfileRequestContext in servlet request");
                request.setAttribute("opensamlProfileRequestContext", (Object)prc);
            }
        }
    }

    public void resuming(RequestContext context) {
        assert (context != null);
        ProfileRequestContext prc = this.getProfileRequestContext(context);
        ServletRequest request = this.getRequest(context);
        if (prc != null && request != null) {
            this.log.trace("Updating ProfileRequestContext in servlet request");
            request.setAttribute("opensamlProfileRequestContext", (Object)prc);
        }
    }

    @Nullable
    private ProfileRequestContext getProfileRequestContext(@Nonnull RequestContext context) {
        Object prc = context.getConversationScope().get("opensamlProfileRequestContext");
        if (prc instanceof ProfileRequestContext) {
            return (ProfileRequestContext)prc;
        }
        return null;
    }

    @Nullable
    private ServletRequest getRequest(@Nonnull RequestContext context) {
        Object o = context.getExternalContext().getNativeRequest();
        if (o instanceof ServletRequest) {
            return (ServletRequest)o;
        }
        return null;
    }
}

