/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfigurationResolver;
import net.shibboleth.profile.relyingparty.VerifiedProfileCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public final class SelectRelyingPartyConfiguration
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectRelyingPartyConfiguration.class);
    @NonnullAfterInit
    private ReloadableService<RelyingPartyConfigurationResolver> rpConfigResolver;
    @Nonnull
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    @Nullable
    private RelyingPartyContext relyingPartyCtx;

    public void setRelyingPartyConfigurationResolver(@Nonnull ReloadableService<RelyingPartyConfigurationResolver> resolver) {
        this.checkSetterPreconditions();
        this.rpConfigResolver = (ReloadableService)Constraint.isNotNull(resolver, (String)"Relying party configuration resolver cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.rpConfigResolver == null) {
            throw new ComponentInitializationException("RelyingPartyConfigurationResolver cannot be null");
        }
    }

    public boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.relyingPartyCtx = this.relyingPartyContextLookupStrategy.apply(messageContext);
        RelyingPartyContext ctx = this.relyingPartyCtx;
        if (ctx == null) {
            this.log.debug("{} No relying party context available", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party context available");
        }
        if (ctx.getRelyingPartyId() == null) {
            this.log.debug("{} No relying party ID available", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No relying party ID available");
        }
        return super.doPreInvoke(messageContext);
    }

    public void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        RelyingPartyContext ctx = this.relyingPartyCtx;
        assert (ctx != null);
        String rpId = ctx.getRelyingPartyId();
        assert (rpId != null);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(rpId), new VerifiedProfileCriterion(true)});
        try (ServiceableComponent resolver = this.rpConfigResolver.getServiceableComponent();){
            RelyingPartyConfiguration config = (RelyingPartyConfiguration)((RelyingPartyConfigurationResolver)resolver.getComponent()).resolveSingle((Object)criteria);
            if (config == null) {
                this.log.debug("{} No relying party configuration applies to this request", (Object)this.getLogPrefix());
                throw new MessageHandlerException("No relying party configuration resolved for this request");
            }
            this.log.debug("{} Found relying party configuration {} for request", (Object)this.getLogPrefix(), (Object)config.getId());
            ctx.setConfiguration(config);
        }
        catch (ResolverException e) {
            this.log.error("{} Error trying to resolve relying party configuration: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Error trying to resolve relying party configuration", (Exception)((Object)e));
        }
        catch (ServiceException e) {
            this.log.error("{} Invalid relying party configuration: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException("Invalid relying party configuration", (Exception)((Object)e));
        }
    }
}

