/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.config.ConditionalProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectProfileConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectProfileConfiguration.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nullable
    @NotEmpty
    private String profileId;
    @NonnullBeforeExec
    private RelyingPartyContext rpCtx;
    private boolean failIfMissing = true;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setProfileId(@Nullable @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setFailIfMissing(boolean flag) {
        this.checkSetterPreconditions();
        this.failIfMissing = flag;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        RelyingPartyContext ctx = this.rpCtx;
        if (ctx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (ctx.getConfiguration() == null) {
            this.log.debug("{} No relying party configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String targetId = this.profileId;
        if (targetId == null) {
            targetId = profileRequestContext.getProfileId();
        }
        RelyingPartyConfiguration rpConfig = this.rpCtx.getConfiguration();
        assert (rpConfig != null);
        ProfileConfiguration profileConfiguration = rpConfig.getProfileConfiguration(profileRequestContext, targetId);
        if (profileConfiguration == null && this.profileId == null && profileRequestContext.getLegacyProfileId() != null && (profileConfiguration = rpConfig.getProfileConfiguration(profileRequestContext, profileRequestContext.getLegacyProfileId())) != null) {
            profileRequestContext.setProfileId(profileRequestContext.getLegacyProfileId());
        }
        if (profileConfiguration == null) {
            if (this.failIfMissing) {
                this.log.warn("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            } else {
                this.log.debug("{} Profile {} is not available for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
            }
        } else if (profileConfiguration instanceof ConditionalProfileConfiguration && !((ConditionalProfileConfiguration)profileConfiguration).getActivationCondition().test(profileRequestContext)) {
            if (this.failIfMissing) {
                this.log.warn("{} Profile {} is not active for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            } else {
                this.log.debug("{} Profile {} is not active for RP configuration {} (RPID {})", new Object[]{this.getLogPrefix(), targetId, rpConfig.getId(), this.rpCtx.getRelyingPartyId()});
            }
        } else {
            this.rpCtx.setProfileConfig(profileConfiguration);
        }
    }
}

