/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageServiceSearch;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class TemplatedSearchBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<StorageServiceSearch> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedSearchBuilder.class);
    @NonnullAfterInit
    private Template contextTemplate;
    @NonnullAfterInit
    private Template keyTemplate;
    @NonnullAfterInit
    private String contextTemplateText;
    @NonnullAfterInit
    private String keyTemplateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nullable
    private Object customObject;

    @NonnullAfterInit
    public Template getContextTemplate() {
        return this.contextTemplate;
    }

    @NonnullAfterInit
    public Template getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonnullAfterInit
    public String getContextTemplateText() {
        return this.contextTemplateText;
    }

    public void setContextTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.contextTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public String getKeyTemplateText() {
        return this.keyTemplateText;
    }

    public void setKeyTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.keyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        this.checkSetterPreconditions();
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    protected void doInitialize() throws ComponentInitializationException {
        VelocityEngine localEngine = this.engine;
        String localKeyTemplateText = this.keyTemplateText;
        String localContextTemplateText = this.contextTemplateText;
        if (null == localEngine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null == localContextTemplateText) {
            throw new ComponentInitializationException("Context template text cannot be null");
        }
        if (null == localKeyTemplateText) {
            throw new ComponentInitializationException("Key template text cannot be null");
        }
        this.contextTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)localContextTemplateText);
        this.keyTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)localKeyTemplateText);
    }

    @Nonnull
    public StorageServiceSearch build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        final ContextAndKey searchParams = this.getContextAndKey(resolutionContext, dependencyAttributes);
        return new StorageServiceSearch(){

            @Nullable
            public String getResultCacheKey() {
                return searchParams.context() + "!" + searchParams.key();
            }

            @Nullable
            public StorageRecord<?> execute(@Nonnull StorageService storageService) throws IOException {
                String ctx = searchParams.context();
                String key = searchParams.key();
                assert (ctx != null && key != null);
                return storageService.read(ctx, key);
            }
        };
    }

    @Nonnull
    private ContextAndKey getContextAndKey(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating search criteria using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("custom", this.customObject);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        try {
            String ctx = this.contextTemplate.merge((Context)context);
            String key = this.keyTemplate.merge((Context)context);
            this.log.debug("Produced search context '{}', key '{}'", (Object)ctx, (Object)key);
            return new ContextAndKey(ctx, key);
        }
        catch (VelocityException e) {
            this.log.error("Error running template engine: {}", (Object)e.getMessage());
            throw new ResolutionException("Error running template engine", (Exception)((Object)e));
        }
    }

    public record ContextAndKey(@Nonnull String context, @Nonnull String key) {
        public ContextAndKey(@Nonnull String context, @Nonnull String key) {
            this.context = Constraint.isNotEmpty((String)context, (String)"Context cannot be null or empty");
            this.key = Constraint.isNotEmpty((String)key, (String)"Key cannot be null or empty");
        }
    }
}

