/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.util.impl;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;

public class SubjectMatchProcessor {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SubjectMatchProcessor.class);

    public void process(@Nonnull ResponseData responseData) {
        MessageContext outboundContext = responseData.getSOAPClientContext().getOutboundMessageContext();
        assert (outboundContext != null);
        AttributeQuery query = (AttributeQuery)outboundContext.getMessage();
        assert (query != null);
        Subject querySubject = query.getSubject();
        assert (querySubject != null);
        LinkedList<Assertion> toRemove = new LinkedList<Assertion>();
        for (Assertion assertion : responseData.getResponse().getAssertions()) {
            Issuer assertionIssuer = assertion.getIssuer();
            Subject assertionSubject = assertion.getSubject();
            if (assertionSubject == null) {
                this.log.warn("Assertion '{}' from Issuer '{}' did not contain Subject, removing", (Object)assertion.getID(), (Object)(assertionIssuer != null ? assertionIssuer.getValue() : "null"));
                toRemove.add(assertion);
                continue;
            }
            if (SAML2ObjectSupport.matchSubject((Subject)assertionSubject, (Subject)querySubject)) continue;
            this.log.warn("Subject of Assertion '{}' from Issuer '{}' did not match query Subject, removing", (Object)assertion.getID(), (Object)(assertionIssuer != null ? assertionIssuer.getValue() : "null"));
            toRemove.add(assertion);
        }
        if (!toRemove.isEmpty()) {
            responseData.getResponse().getAssertions().removeAll(toRemove);
            this.log.debug("Removed a total of {} assertions which failed subject match processing", (Object)toRemove.size());
        }
    }
}

