/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.saml.ExecutableQuery;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.AttributeAuthorityEntityIDResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SelfEntityIDResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SubjectResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.MessageException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.messaging.soap.SAMLSOAPClientContextBuilder;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.slf4j.Logger;

public class ExecutableQueryBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<ExecutableQuery> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExecutableQueryBuilder.class);
    @NonnullAfterInit
    private EndpointResolver<AttributeService> authorityEndpointResolver;
    @NonnullAfterInit
    private RoleDescriptorResolver roleDescriptorResolver;
    @NonnullAfterInit
    private String soapPipelineName;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idStrategy;
    @NonnullAfterInit
    private String soapClientSecurityConfigurationProfileId;
    @NonnullAfterInit
    private AttributeAuthorityEntityIDResolver authorityEntityIDStrategy;
    @NonnullAfterInit
    private SelfEntityIDResolver selfEntityIDStrategy;
    @NonnullAfterInit
    private SubjectResolver subjectStrategy;
    @Nonnull
    private List<Attribute> requestedAttributes = CollectionSupport.emptyList();

    @NonnullAfterInit
    public EndpointResolver<AttributeService> getAuthorityEndpointResolver() {
        return this.authorityEndpointResolver;
    }

    public void setAuthorityEndpointResolver(@Nullable EndpointResolver<AttributeService> resolver) {
        this.checkSetterPreconditions();
        this.authorityEndpointResolver = resolver;
    }

    @NonnullAfterInit
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    public void setRoleDescriptorResolver(@Nullable RoleDescriptorResolver resolver) {
        this.checkSetterPreconditions();
        this.roleDescriptorResolver = resolver;
    }

    @NonnullAfterInit
    public String getSOAPPipelineName() {
        return this.soapPipelineName;
    }

    public void setSOAPPipelineName(@Nullable String name) {
        this.checkSetterPreconditions();
        this.soapPipelineName = StringSupport.trimOrNull((String)name);
    }

    @NonnullAfterInit
    public IdentifierGenerationStrategy getIdentifierGenerationStrategy() {
        return this.idStrategy;
    }

    public void setIdentifierGenerationStrategy(@Nonnull IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.idStrategy = strategy;
    }

    @NonnullAfterInit
    public String getSOAPClientSecurityConfigurationProfileId() {
        return this.soapClientSecurityConfigurationProfileId;
    }

    public void setSOAPClientSecurityConfigurationProfileId(@Nullable String profileId) {
        this.checkSetterPreconditions();
        this.soapClientSecurityConfigurationProfileId = StringSupport.trimOrNull((String)profileId);
    }

    @NonnullAfterInit
    public AttributeAuthorityEntityIDResolver getAuthorityEntityIDStrategy() {
        return this.authorityEntityIDStrategy;
    }

    public void setAuthorityEntityIDStrategy(@Nonnull AttributeAuthorityEntityIDResolver strategy) {
        this.checkSetterPreconditions();
        this.authorityEntityIDStrategy = strategy;
    }

    @NonnullAfterInit
    public SelfEntityIDResolver getSelfEntityIDStrategy() {
        return this.selfEntityIDStrategy;
    }

    public void setSelfEntityIDStrategy(@Nonnull SelfEntityIDResolver strategy) {
        this.checkSetterPreconditions();
        this.selfEntityIDStrategy = strategy;
    }

    @NonnullAfterInit
    public SubjectResolver getSubjectStrategy() {
        return this.subjectStrategy;
    }

    public void setSubjectStrategy(@Nonnull SubjectResolver strategy) {
        this.checkSetterPreconditions();
        this.subjectStrategy = strategy;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Attribute> getRequestedAttributes() {
        return this.requestedAttributes;
    }

    public void setRequestedAttributes(@Nullable List<Attribute> attributes) {
        this.requestedAttributes = attributes == null ? CollectionSupport.emptyList() : (List)((NonnullSupplier)attributes.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAuthorityEndpointResolver() == null) {
            throw new ComponentInitializationException("Authority EndpointResolver was null");
        }
        if (this.getAuthorityEntityIDStrategy() == null) {
            throw new ComponentInitializationException("Authority entityID strategy was null");
        }
        if (this.getSelfEntityIDStrategy() == null) {
            throw new ComponentInitializationException("Self entityID strategy was null");
        }
        if (this.getSubjectStrategy() == null) {
            throw new ComponentInitializationException("Subject strategy was null");
        }
        if (this.getIdentifierGenerationStrategy() == null) {
            throw new ComponentInitializationException("IdentifierGenerationStrategy was null");
        }
        if (this.getRoleDescriptorResolver() == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver was null");
        }
        if (this.getSOAPClientSecurityConfigurationProfileId() == null) {
            throw new ComponentInitializationException("SOAP client security configuration profile ID was null");
        }
        if (this.getSOAPPipelineName() == null) {
            throw new ComponentInitializationException("SOAP pipeline name was null");
        }
    }

    @Nonnull
    public ExecutableQuery build(final @Nonnull AttributeResolutionContext resolutionContext, final @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        this.checkComponentActive();
        final String authorityEntityID = this.resolveAttributeAuthorityEntityID(resolutionContext, dependencyAttributes);
        final AttributeAuthorityDescriptor authorityRoleDescriptor = this.resolveAuthorityRoleDescriptor(authorityEntityID);
        final String authorityEndpoint = this.resolveAuthorityEndpoint(authorityEntityID, authorityRoleDescriptor);
        final InOutOperationContext opContext = this.buildOperationContext(resolutionContext, dependencyAttributes, authorityRoleDescriptor, authorityEndpoint);
        return new ExecutableQuery(){
            @Nonnull
            private final Logger log = LoggerFactory.getLogger(ExecutableQuery.class);

            @Nullable
            public String getResultCacheKey() {
                MessageContext outbound = opContext.getOutboundMessageContext();
                assert (outbound != null);
                AttributeQuery query = (AttributeQuery)outbound.getMessage();
                assert (query != null);
                Subject subject = query.getSubject();
                assert (subject != null);
                NameID nameid = subject.getNameID();
                assert (nameid != null);
                List<String> attribNames = query.getAttributes().stream().map(Attribute::getName).sorted().toList();
                StringBuilder builder = new StringBuilder();
                builder.append(authorityEntityID);
                builder.append(":");
                builder.append(nameid.getValue());
                if (attribNames.size() > 0) {
                    builder.append(":");
                    builder.append(StringSupport.listToStringValue(attribNames, (String)","));
                }
                return builder.toString();
            }

            public String toString() {
                return this.getResultCacheKey();
            }

            @Nonnull
            public ResponseData execute(@Nonnull SOAPClient soapClient) throws SAMLException, SOAPException, SecurityException {
                Object message;
                this.log.trace("Executing AttributeQuery over SOAP 1.1 binding to endpoint: {}", (Object)authorityEndpoint);
                soapClient.send(authorityEndpoint, opContext);
                MessageContext inboundContext = opContext.getInboundMessageContext();
                Object object = message = inboundContext != null ? inboundContext.getMessage() : null;
                if (message instanceof Response) {
                    Response response = (Response)message;
                    this.validateResponse(response);
                    return new ResponseData(response, opContext, resolutionContext, dependencyAttributes, (RoleDescriptor)authorityRoleDescriptor);
                }
                throw new SOAPException("SOAP message payload was not an instance of Response: " + (message != null ? message.getClass().getName() : "(null)"));
            }

            private void validateResponse(@Nonnull Response response) throws SAMLException {
                StatusCode statusCode;
                Status status = response.getStatus();
                StatusCode statusCode2 = statusCode = status != null ? status.getStatusCode() : null;
                if (statusCode == null || statusCode.getValue() == null) {
                    throw new SAMLException("Response included no StatusCode, could not validate");
                }
                if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode.getValue())) {
                    throw new SAMLException("Response carried non-success StatusCode: " + statusCode.getValue());
                }
            }
        };
    }

    @Nonnull
    private String resolveAttributeAuthorityEntityID(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        String entityID = this.getAuthorityEntityIDStrategy().resolve(resolutionContext, dependencyAttributes);
        if (entityID != null) {
            return entityID;
        }
        throw new ResolutionException("Unable to resolve AttributeAuthority entityID");
    }

    @Nonnull
    private AttributeAuthorityDescriptor resolveAuthorityRoleDescriptor(@Nonnull String authorityEntityID) throws ResolutionException {
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(authorityEntityID), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"), new EntityRoleCriterion(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME)});
        try {
            AttributeAuthorityDescriptor descriptor = (AttributeAuthorityDescriptor)this.roleDescriptorResolver.resolveSingle((Object)criteriaSet);
            if (descriptor != null) {
                this.log.debug("Successfully resolved AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID);
                return descriptor;
            }
            this.log.warn("Failed to resolve AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID);
            throw new ResolutionException("Failed to resolve AttributeAuthorityDescriptor for entityID: " + authorityEntityID);
        }
        catch (ResolverException e) {
            this.log.warn("Fatal error resolving AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID, (Object)e);
            throw new ResolutionException("Failed to resolve AttributeAuthorityDescriptor", (Exception)((Object)e));
        }
    }

    @Nonnull
    private String resolveAuthorityEndpoint(@Nonnull String authorityEntityID, @Nonnull AttributeAuthorityDescriptor authorityRoleDescriptor) throws ResolutionException {
        RoleDescriptorCriterion roleDescriptorCriterion = new RoleDescriptorCriterion((RoleDescriptor)authorityRoleDescriptor);
        AttributeService serviceTemplate = (AttributeService)XMLObjectSupport.buildXMLObject((QName)AttributeService.DEFAULT_ELEMENT_NAME);
        serviceTemplate.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        EndpointCriterion endpointCriterion = new EndpointCriterion((Endpoint)serviceTemplate, false);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{roleDescriptorCriterion, endpointCriterion});
        try {
            AttributeService service = (AttributeService)this.authorityEndpointResolver.resolveSingle((Object)criteriaSet);
            if (service != null) {
                String location = service.getLocation();
                if (location != null) {
                    this.log.debug("Successfully resolved AttibuteService for entityID: {}", (Object)authorityEntityID);
                    return location;
                }
                this.log.warn("Failed to resolve AttibuteService Location for entityID: {}", (Object)authorityEntityID);
                throw new ResolutionException("Failed to resolve AttibuteService Location for entityID: " + authorityEntityID);
            }
            this.log.warn("Failed to resolve AttibuteService for entityID: {}", (Object)authorityEntityID);
            throw new ResolutionException("Failed to resolve AttibuteService for entityID: " + authorityEntityID);
        }
        catch (ResolverException e) {
            this.log.warn("Fatal error resolving AttributeService for entityID: {}", (Object)authorityEntityID, (Object)e);
            throw new ResolutionException("Failed to resolve AttributeService", (Exception)((Object)e));
        }
    }

    @Nonnull
    private InOutOperationContext buildOperationContext(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor, @Nonnull String endpoint) throws ResolutionException {
        String selfEntityID = this.resolveSelfEntityID(resolutionContext, dependencyAttributes, roleDescriptor);
        try {
            return new SAMLSOAPClientContextBuilder().setOutboundMessage(this.buildAttributeQueryMessage(resolutionContext, dependencyAttributes, roleDescriptor, endpoint, selfEntityID)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol").setPipelineName(this.getSOAPPipelineName()).setPeerRoleDescriptor((RoleDescriptor)roleDescriptor).setSelfEntityID(selfEntityID).setSecurityConfigurationProfileId(this.getSOAPClientSecurityConfigurationProfileId()).build();
        }
        catch (MessageException e) {
            throw new ResolutionException("Fatal error building operation context for SAML AttributeQuery", (Exception)((Object)e));
        }
    }

    @Nonnull
    private String resolveSelfEntityID(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        String entityID = this.getSelfEntityIDStrategy().resolve(resolutionContext, dependencyAttributes, roleDescriptor);
        if (entityID != null) {
            return entityID;
        }
        throw new ResolutionException("Unable to resolve self entityID");
    }

    @Nonnull
    private SAMLObject buildAttributeQueryMessage(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor, @Nonnull String endpoint, @Nonnull String selfEntityID) throws ResolutionException {
        AttributeQuery query = (AttributeQuery)XMLObjectSupport.buildXMLObject((QName)AttributeQuery.DEFAULT_ELEMENT_NAME);
        query.setID(this.idStrategy.generateIdentifier(true));
        query.setDestination(endpoint);
        query.setIssueInstant(Instant.now());
        query.setIssuer(this.buildIssuer(selfEntityID));
        query.setSubject(this.buildSubject(resolutionContext, dependencyAttributes, roleDescriptor));
        query.getAttributes().addAll(this.buildRequestAttributes(resolutionContext, dependencyAttributes, roleDescriptor));
        return query;
    }

    @Nonnull
    private Issuer buildIssuer(@Nonnull String selfEntityID) throws ResolutionException {
        Issuer issuer = (Issuer)XMLObjectSupport.buildXMLObject((QName)Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(selfEntityID);
        return issuer;
    }

    @Nonnull
    private Subject buildSubject(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        Subject subject = this.getSubjectStrategy().resolve(resolutionContext, dependencyAttributes, roleDescriptor);
        if (subject != null) {
            try {
                return (Subject)XMLObjectSupport.cloneXMLObject((XMLObject)subject);
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new ResolutionException("Error cloning Subject", (Exception)e);
            }
        }
        throw new ResolutionException("Unable to resolve self entityID");
    }

    @Nonnull
    private List<Attribute> buildRequestAttributes(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes, @Nonnull AttributeAuthorityDescriptor roleDescriptor) throws ResolutionException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute attr : this.getRequestedAttributes()) {
            assert (attr != null);
            try {
                attributes.add((Attribute)XMLObjectSupport.cloneXMLObject((XMLObject)attr));
            }
            catch (MarshallingException | UnmarshallingException e) {
                throw new ResolutionException("Error cloning requested Attribute", (Exception)e);
            }
        }
        return attributes;
    }
}

