/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.saml.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseData;
import net.shibboleth.idp.attribute.resolver.dc.saml.ResponseMappingStrategy;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class BasicResponseMappingStrategy
extends AbstractInitializableComponent
implements ResponseMappingStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicResponseMappingStrategy.class);
    @NonnullAfterInit
    private AttributeTranscoderRegistry transcoderRegistry;
    @NonnullAfterInit
    private MetadataResolver metadataResolver;
    @NonnullAfterInit
    private RoleDescriptorResolver roleDescriptorResolver;
    @NonnullAfterInit
    private ReloadableService<AttributeFilter> filterService;
    private boolean filterAttributes = true;

    @NonnullAfterInit
    public AttributeTranscoderRegistry getTranscoderRegistry() {
        return this.transcoderRegistry;
    }

    public void setTranscoderRegistry(@Nullable AttributeTranscoderRegistry registry) {
        this.checkSetterPreconditions();
        this.transcoderRegistry = registry;
    }

    @NonnullAfterInit
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.checkSetterPreconditions();
        this.metadataResolver = resolver;
    }

    @NonnullAfterInit
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    public void setRoleDescriptorResolver(@Nullable RoleDescriptorResolver resolver) {
        this.checkSetterPreconditions();
        this.roleDescriptorResolver = resolver;
    }

    public ReloadableService<AttributeFilter> getAttributeFilterService() {
        return this.filterService;
    }

    public void setAttributeFilterService(@Nullable ReloadableService<AttributeFilter> service) {
        this.checkSetterPreconditions();
        this.filterService = service;
    }

    public boolean isFilterAttributes() {
        return this.filterAttributes;
    }

    public void setFilterAttributes(boolean flag) {
        this.filterAttributes = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getTranscoderRegistry() == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry was null");
        }
        if (this.getMetadataResolver() == null) {
            throw new ComponentInitializationException("MetadataResolver was null");
        }
        if (this.getRoleDescriptorResolver() == null) {
            throw new ComponentInitializationException("RoleDescriptorResolver was null");
        }
        if (this.getAttributeFilterService() == null) {
            throw new ComponentInitializationException("AttributeFilter service was null");
        }
    }

    @Nullable
    public Map<String, IdPAttribute> map(@Nonnull ResponseData responseData) throws ResolutionException {
        this.checkComponentActive();
        LinkedList<IdPAttribute> aggregateResults = new LinkedList<IdPAttribute>();
        ProfileRequestContext profileContext = (ProfileRequestContext)responseData.getAttributeResolutionContext().getProfileRequestContextLookupStrategy().apply(responseData.getAttributeResolutionContext());
        if (profileContext != null) {
            this.log.trace("For transcoding successfully resolved ProfileRequestContext");
        } else {
            this.log.trace("For transcoding failed to resolve ProfileRequestContext, some features may be unavailable");
        }
        for (Assertion assertion : responseData.getResponse().getAssertions()) {
            String assertionIssuerID = null;
            Issuer assertionIssuer = assertion.getIssuer();
            if (assertionIssuer != null) {
                assertionIssuerID = assertionIssuer.getValue();
            }
            this.log.debug("Processing attributes from Assertion '{}' issued by '{}'", (Object)assertion.getID(), (Object)(assertionIssuerID != null ? assertionIssuerID : "<unknown>"));
            LinkedList<IdPAttribute> assertionResults = new LinkedList<IdPAttribute>();
            for (AttributeStatement statement : assertion.getAttributeStatements()) {
                for (Attribute samlAttribute : statement.getAttributes()) {
                    assert (samlAttribute != null);
                    assertionResults.addAll(this.transcodeAttribute(samlAttribute, profileContext));
                }
            }
            aggregateResults.addAll(this.processAssertionFiltering(assertion, assertionResults, assertionIssuerID, profileContext, responseData));
        }
        Map mergedResults = IdPAttributeSupport.toMapMergeDuplicates(aggregateResults);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Decoded {} total unique attribute IDs:", (Object)mergedResults.keySet().size());
            for (String attributeID : mergedResults.keySet().stream().sorted().toList()) {
                this.log.trace("\tAttribute ID '{}', # of values: {}", (Object)attributeID, (Object)((IdPAttribute)mergedResults.get(attributeID)).getValues().size());
            }
        }
        return mergedResults;
    }

    @Nonnull
    private List<IdPAttribute> transcodeAttribute(@Nonnull Attribute samlAttribute, @Nullable ProfileRequestContext profileContext) {
        LinkedList<IdPAttribute> attributeResults = new LinkedList<IdPAttribute>();
        Collection transcodingRules = this.getTranscoderRegistry().getTranscodingRules((Object)samlAttribute);
        if (transcodingRules.isEmpty()) {
            this.log.debug("No transcoding rule for Attribute (Name '{}', NameFormat: '{}')", (Object)samlAttribute.getName(), (Object)(samlAttribute.getNameFormat() != null ? samlAttribute.getNameFormat() : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"));
            return CollectionSupport.emptyList();
        }
        for (TranscodingRule rule : transcodingRules) {
            assert (rule != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            try {
                IdPAttribute decodedAttribute = transcoder.decode(profileContext, (Object)samlAttribute, rule);
                if (decodedAttribute == null) continue;
                attributeResults.add(decodedAttribute);
            }
            catch (Exception e) {
                this.log.warn("Error transcoding for Attribute (Name '{}', NameFormat: '{}') via transcoder: {}", new Object[]{samlAttribute.getName(), samlAttribute.getNameFormat() != null ? samlAttribute.getNameFormat() : "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", transcoder.getClass().getName(), e});
            }
        }
        return attributeResults;
    }

    @Nonnull
    private Collection<IdPAttribute> processAssertionFiltering(@Nonnull Assertion assertion, @Nonnull List<IdPAttribute> assertionResults, @Nullable String assertionIssuerID, @Nullable ProfileRequestContext profileContext, @Nonnull ResponseData responseData) {
        if (this.isFilterAttributes()) {
            if (assertionIssuerID != null && profileContext != null) {
                this.log.debug("Filtering attributes decoded from Assertion '{}' issued by '{}'", (Object)assertion.getID(), (Object)assertionIssuerID);
                return this.filterAssertionResults(assertionResults, assertionIssuerID, profileContext, responseData);
            }
            this.log.error("Attribute filtering enabled, but Assertion Issuer or ProfileRequestContext unknown,  unable to filter and include attributes in result set from Assertion '{}'", (Object)assertion.getID());
            return CollectionSupport.emptyList();
        }
        this.log.debug("Attribute filtering disabled, adding all attributes from Assertion '{}' issued by '{}'", (Object)assertion.getID(), (Object)(assertionIssuerID != null ? assertionIssuerID : "<unknown>"));
        return assertionResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Collection<IdPAttribute> filterAssertionResults(@Nonnull List<IdPAttribute> assertionResults, @Nonnull String assertionIssuerID, @Nonnull ProfileRequestContext profileContext, @Nonnull ResponseData responseData) {
        AttributeFilterContext filterContext = (AttributeFilterContext)profileContext.ensureSubcontext(AttributeFilterContext.class);
        Map unfilteredAttributes = IdPAttributeSupport.toMapMergeDuplicates(assertionResults);
        this.populateFilterContext(filterContext, unfilteredAttributes, assertionIssuerID, responseData);
        try {
            List list;
            block17: {
                ServiceableComponent component;
                block15: {
                    Collection<IdPAttribute> collection;
                    block16: {
                        component = this.getAttributeFilterService().getServiceableComponent();
                        try {
                            Collection<IdPAttribute> filteredValues;
                            AttributeFilter filter = (AttributeFilter)component.getComponent();
                            filter.filterAttributes(filterContext);
                            Map filtered = filterContext.getFilteredIdPAttributes();
                            if (filtered == null || (filteredValues = filtered.values()) == null) break block15;
                            collection = filteredValues;
                            if (component == null) break block16;
                        }
                        catch (Throwable throwable) {
                            List list2;
                            try {
                                if (component != null) {
                                    try {
                                        component.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (AttributeFilterException e) {
                                this.log.error("Error while filtering inbound attributes", (Throwable)e);
                                list2 = CollectionSupport.emptyList();
                                return list2;
                            }
                            catch (ServiceException e) {
                                this.log.error("Invalid AttributeFilter configuration", (Throwable)e);
                                list2 = CollectionSupport.emptyList();
                                return list2;
                            }
                        }
                        component.close();
                    }
                    return collection;
                }
                list = CollectionSupport.emptyList();
                if (component == null) break block17;
                component.close();
            }
            return list;
        }
        finally {
            filterContext.removeFromParent();
        }
    }

    private void populateFilterContext(@Nonnull AttributeFilterContext filterContext, @Nonnull Map<String, IdPAttribute> unfilteredAttributes, @Nonnull String assertionIssuer, @Nonnull ResponseData responseData) {
        SAMLMetadataContext issuerMetadataContext = this.resolveIssuerMetadataContext(responseData, assertionIssuer);
        String selfEntityID = this.resolveSelfEntityID(responseData);
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(unfilteredAttributes).setMetadataResolver(this.getMetadataResolver()).setIssuerMetadataContextLookupStrategy(t -> issuerMetadataContext).setAttributeIssuerID(assertionIssuer).setAttributeRecipientID(selfEntityID);
    }

    @Nullable
    private String resolveSelfEntityID(@Nonnull ResponseData responseData) {
        return ((SAMLSelfEntityContext)responseData.getSOAPClientContext().ensureSubcontext(SAMLSelfEntityContext.class)).getEntityId();
    }

    @Nonnull
    private SAMLMetadataContext resolveIssuerMetadataContext(@Nonnull ResponseData responseData, @Nonnull String assertionIssuer) {
        XMLObject xMLObject;
        SAMLPeerEntityContext peerEntityContext = this.resolvePeerEntityContext(responseData);
        if (assertionIssuer.equals(peerEntityContext.getEntityId())) {
            SAMLMetadataContext peerMetadataContext = (SAMLMetadataContext)peerEntityContext.getSubcontext(SAMLMetadataContext.class);
            if (peerMetadataContext != null && peerMetadataContext.getEntityDescriptor() != null && peerMetadataContext.getRoleDescriptor() != null) {
                this.log.debug("Assertion issuer same as Response, resolved SAMLMetadataContext from SOAP client context");
                return peerMetadataContext;
            }
            this.log.debug("Assertion issuer same as Response but context data incomplete, resolving data for SAMLMetadataContext");
        } else {
            this.log.debug("Assertion issuer NOT same as Response, resolving data for SAMLMetadataContext");
        }
        SAMLMetadataContext metadataContext = new SAMLMetadataContext();
        AttributeAuthorityDescriptor roleDescriptor = this.resolveAuthorityRoleDescriptor(assertionIssuer);
        metadataContext.setRoleDescriptor((RoleDescriptor)roleDescriptor);
        if (roleDescriptor != null && (xMLObject = roleDescriptor.getParent()) instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)xMLObject;
            metadataContext.setEntityDescriptor(entityDescriptor);
        }
        return metadataContext;
    }

    @Nonnull
    private SAMLPeerEntityContext resolvePeerEntityContext(@Nonnull ResponseData responseData) {
        return (SAMLPeerEntityContext)responseData.getSOAPClientContext().ensureSubcontext(SAMLPeerEntityContext.class);
    }

    @Nullable
    private AttributeAuthorityDescriptor resolveAuthorityRoleDescriptor(@Nonnull String authorityEntityID) {
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(authorityEntityID), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"), new EntityRoleCriterion(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME)});
        try {
            AttributeAuthorityDescriptor descriptor = (AttributeAuthorityDescriptor)this.getRoleDescriptorResolver().resolveSingle((Object)criteriaSet);
            if (descriptor != null) {
                this.log.debug("Successfully resolved AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID);
                return descriptor;
            }
            this.log.warn("Failed to resolve AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID);
            return null;
        }
        catch (ResolverException e) {
            this.log.warn("Fatal error resolving AttributeAuthorityDescriptor for entityID: {}", (Object)authorityEntityID, (Object)e);
            return null;
        }
    }
}

