/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ContextDerivedDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ContextDerivedDataConnector.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<IdPAttribute>> attributesFunction;
    private boolean noResultIsError;

    @NonnullAfterInit
    public Function<ProfileRequestContext, List<IdPAttribute>> getAttributesFunction() {
        return this.attributesFunction;
    }

    public void setAttributesFunction(@Nonnull Function<ProfileRequestContext, List<IdPAttribute>> function) {
        this.checkSetterPreconditions();
        this.attributesFunction = (Function)Constraint.isNotNull(function, (String)"Attribute Function cannot be null");
    }

    public boolean isNoResultIsError() {
        return this.noResultIsError;
    }

    public void setNoResultIsError(boolean flag) {
        this.checkSetterPreconditions();
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributesFunction == null) {
            throw new ComponentInitializationException("Attribute lookup strategy cannot be null");
        }
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        List<IdPAttribute> results = this.attributesFunction.apply((ProfileRequestContext)resolutionContext.getProfileRequestContextLookupStrategy().apply(resolutionContext));
        if (null == results || results.isEmpty()) {
            if (this.noResultIsError) {
                throw new NoResultAnErrorResolutionException(this.getLogPrefix() + " No attributes returned");
            }
            this.log.debug("{} Generated no attributes", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} attributes", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Attributes: {}", (Object)this.getLogPrefix(), results);
        return results.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, Function.identity()));
    }
}

