/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.http.HTTPResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.HTTPSearch;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;

public class HTTPDataConnector
extends AbstractSearchDataConnector<HTTPSearch, HTTPResponseMappingStrategy> {
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    public HTTPDataConnector() {
        this.setValidator(new Validator(){

            public void validate(@Nonnull DataConnector dataConnector) throws ValidationException {
            }

            public void setThrowValidateError(boolean what) {
            }

            public boolean isThrowValidateError() {
                return false;
            }
        });
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        try {
            super.doInitialize();
            if (this.httpClient == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " HttpClient cannot be null");
            }
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull HTTPSearch executable) throws ResolutionException {
        try {
            HTTPResponseMappingStrategy strategy = (HTTPResponseMappingStrategy)this.getMappingStrategy();
            HttpClient localClient = this.httpClient;
            assert (strategy != null && localClient != null);
            return strategy.map((Object)executable.execute(localClient, this.httpClientSecurityParameters, strategy));
        }
        catch (IOException e) {
            throw new ResolutionException(this.getLogPrefix() + " HTTP request failed", (Exception)e);
        }
    }
}

