/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import com.google.common.base.MoreObjects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class SourceValue
extends AbstractInitializableComponent {
    @Nullable
    private String value;
    private boolean caseSensitive = true;
    @Nullable
    private Pattern pattern;
    private boolean partialMatch;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.partialMatch && this.value != null) {
            int flags = 0;
            if (!this.isCaseSensitive()) {
                flags = 2;
            }
            this.pattern = Pattern.compile(this.value, flags);
        } else {
            this.pattern = null;
        }
    }

    public void setCaseSensitive(boolean theCaseSensitive) {
        this.checkSetterPreconditions();
        this.caseSensitive = theCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPartialMatch(boolean thePartialMatch) {
        this.checkSetterPreconditions();
        this.partialMatch = thePartialMatch;
    }

    public boolean isPartialMatch() {
        return this.partialMatch;
    }

    public void setValue(@Nullable String theValue) {
        this.checkSetterPreconditions();
        this.value = StringSupport.trimOrNull((String)theValue);
    }

    @Nullable
    public String getValue() {
        Constraint.isTrue((boolean)this.isPartialMatch(), (String)"getValue is only meaningful for a partialMatch, use getPattern()");
        return this.value;
    }

    @Nullable
    public Pattern getPattern() {
        this.checkComponentActive();
        Constraint.isFalse((boolean)this.isPartialMatch(), (String)"getPattern is only meaningful for a non partial Match, use getValue()");
        return this.pattern;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", (Object)this.value).add("caseSensitive", this.isCaseSensitive()).add("isPartialMatch", this.isPartialMatch()).toString();
    }
}

