/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.mapped.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.mapped.impl.ValueMap;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

@ThreadSafe
public class MappedAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MappedAttributeDefinition.class);
    @Nonnull
    private Set<ValueMap> valueMaps = CollectionSupport.emptySet();
    private boolean passThru;
    @Nullable
    private StringAttributeValue defaultValue;

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<ValueMap> getValueMaps() {
        return this.valueMaps;
    }

    public void setValueMaps(@Nullable Collection<ValueMap> mappings) {
        this.checkSetterPreconditions();
        this.valueMaps = mappings != null ? CollectionSupport.copyToSet(mappings) : CollectionSupport.emptySet();
    }

    @Nullable
    public StringAttributeValue getDefaultAttributeValue() {
        return this.defaultValue;
    }

    @Nullable
    public String getDefaultValue() {
        if (null != this.defaultValue) {
            return this.defaultValue.getValue();
        }
        return null;
    }

    public void setDefaultValue(@Nullable String newDefaultValue) {
        this.checkSetterPreconditions();
        String trimmedDefault = StringSupport.trimOrNull((String)newDefaultValue);
        this.defaultValue = null == trimmedDefault ? null : new StringAttributeValue(trimmedDefault);
    }

    public boolean isPassThru() {
        return this.passThru;
    }

    public void setPassThru(boolean newPassThru) {
        this.checkSetterPreconditions();
        this.passThru = newPassThru;
    }

    @Nonnull
    @Live
    protected List<StringAttributeValue> mapValue(@Nullable String value) {
        this.log.debug("Attribute Definition {}: mapping dependency attribute value {}", (Object)this.getId(), (Object)value);
        ArrayList<StringAttributeValue> mappedValues = new ArrayList<StringAttributeValue>();
        if (!Strings.isNullOrEmpty((String)value)) {
            boolean valueMapMatch = false;
            for (ValueMap valueMap : this.valueMaps) {
                mappedValues.addAll(valueMap.apply(value));
                if (mappedValues.isEmpty()) continue;
                valueMapMatch = true;
            }
            if (!valueMapMatch) {
                if (this.passThru) {
                    assert (value != null);
                    mappedValues.add(new StringAttributeValue(value));
                } else if (this.defaultValue != null) {
                    mappedValues.add(this.defaultValue);
                }
            }
        }
        this.log.debug("Attribute Definition {}: mapped dependency attribute value {} to the values {}", new Object[]{this.getId(), value, mappedValues});
        return mappedValues;
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)resolutionContext, (String)"Attribute resolution context can not be null");
        List unmappedResults = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.ensureId());
        this.log.debug("Attribute Definition '{}': Attempting to map the following values: {}", (Object)this.ensureId(), (Object)unmappedResults);
        IdPAttribute resultAttribute = new IdPAttribute(this.ensureId());
        if (unmappedResults == null || unmappedResults.isEmpty()) {
            this.log.debug("Attribute Definition {}: No values from dependencies", (Object)this.getId());
            if (null != this.defaultValue) {
                this.log.debug("Attribute Definition {}: Default value of {} added as the value for this attribute", (Object)this.getId(), (Object)this.defaultValue);
                assert (this.defaultValue != null);
                resultAttribute.setValues(CollectionSupport.singletonList((Object)this.defaultValue));
            }
        } else {
            ArrayList<StringAttributeValue> valueList = new ArrayList<StringAttributeValue>();
            for (IdPAttributeValue unmappedValue : unmappedResults) {
                if (unmappedValue instanceof EmptyAttributeValue) {
                    valueList.addAll(this.mapValue(null));
                    continue;
                }
                if (unmappedValue instanceof StringAttributeValue) {
                    valueList.addAll(this.mapValue(((StringAttributeValue)unmappedValue).getValue()));
                    continue;
                }
                throw new ResolutionException((Exception)new UnsupportedAttributeTypeException("Attribute definition '" + this.getId() + "' does not support dependency values of type " + unmappedValue.getClass().getName()));
            }
            resultAttribute.setValues(valueList);
        }
        return resultAttribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getAttributeDependencies().isEmpty() && this.getDataConnectorDependencies().isEmpty()) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no dependencies were configured");
        }
        if (this.valueMaps.isEmpty()) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no value mappings were configured");
        }
    }
}

