/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

@Deprecated(forRemoval=true, since="5.2")
@NotThreadSafe
public final class TrustStore
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TrustStore.class);
    @NonnullAfterInit
    private Path idpHome;
    @NonnullAfterInit
    private String explicitTrustStore;
    @Nullable
    private String pluginId;
    @NonnullAfterInit
    private Path store;
    @NonnullAfterInit
    private Path backup;
    @NonnullAfterInit
    private PGPPublicKeyRingCollection keyRings;

    public void setPluginId(String what) {
        this.checkSetterPreconditions();
        this.pluginId = what;
    }

    public void setIdpHome(@Nonnull Path what) {
        this.checkSetterPreconditions();
        this.idpHome = what;
    }

    public void setTrustStore(@Nullable String what) {
        this.checkSetterPreconditions();
        this.explicitTrustStore = what;
    }

    private static PGPPublicKeyRingCollection loadStoreFrom(@Nonnull InputStream in) throws IOException {
        try (InputStream decoded = PGPUtil.getDecoderStream((InputStream)in);){
            Object obj;
            ArrayList<PGPPublicKeyRing> listr = new ArrayList<PGPPublicKeyRing>();
            PGPObjectFactory pgpFact = new PGPObjectFactory(decoded, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            while ((obj = pgpFact.nextObject()) != null) {
                do {
                    if (!(obj instanceof PGPPublicKeyRing)) {
                        throw new IOException(obj.getClass().getName() + " found where PGPPublicKeyRing expected");
                    }
                    listr.add((PGPPublicKeyRing)obj);
                } while ((obj = pgpFact.nextObject()) != null);
                pgpFact = new PGPObjectFactory(decoded, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            }
            PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(listr);
            return pGPPublicKeyRingCollection;
        }
    }

    protected void loadStore() throws IOException {
        try (InputStream in = Files.newInputStream(this.store, new OpenOption[0]);){
            assert (in != null);
            this.keyRings = TrustStore.loadStoreFrom(in);
        }
    }

    protected void createNewStore() throws IOException {
        this.keyRings = new PGPPublicKeyRingCollection((Collection)CollectionSupport.emptyList());
        this.saveStoreInternal();
    }

    public void saveStore() throws IOException {
        this.checkComponentActive();
        this.saveStoreInternal();
    }

    public void saveStoreInternal() throws IOException {
        if (Files.exists(this.store, new LinkOption[0])) {
            Files.copy(this.store, this.backup, StandardCopyOption.REPLACE_EXISTING);
        }
        try (OutputStream outStream = Files.newOutputStream(this.store, new OpenOption[0]);){
            Iterator kit = this.keyRings.getKeyRings();
            while (kit.hasNext()) {
                PGPPublicKey kr = ((PGPPublicKeyRing)kit.next()).getPublicKey();
                StringBuffer comment = new StringBuffer().append("\n\r");
                Iterator sit = kr.getUserIDs();
                if (sit.hasNext()) {
                    comment.append((String)sit.next()).append('\t');
                }
                comment.append("id\t").append(String.format("%X", (int)kr.getKeyID())).append("\n\r");
                outStream.write(comment.toString().getBytes());
                try (ArmoredOutputStream armed = new ArmoredOutputStream(outStream);){
                    kr.encode((OutputStream)armed);
                }
            }
        }
    }

    public void importKeyFromStream(Signature sigForKey, @Nonnull InputStream keyStream, @Nonnull Predicate<String> accept) throws IOException {
        PGPPublicKeyRingCollection providedStore = TrustStore.loadStoreFrom(keyStream);
        PGPPublicKey key = providedStore.getPublicKey(sigForKey.getSignature().getKeyID());
        if (key == null) {
            this.log.info("Provided key stream did not contain a key for {}", (Object)sigForKey);
            return;
        }
        StringBuilder builder = new StringBuilder("Signature:\t").append(sigForKey.toString()).append("\nFingerPrint:\t").append(new String(Hex.encode((byte[])key.getFingerprint())).toUpperCase());
        Iterator namesIterator = key.getUserIDs();
        while (namesIterator.hasNext()) {
            builder.append("\nUsername:\t").append((String)namesIterator.next());
        }
        builder.append('\n');
        String keyInfo = builder.toString();
        this.log.debug("Asking to import key\n{}", (Object)keyInfo);
        if (!accept.test(keyInfo)) {
            this.log.info("Key import barred by user");
            return;
        }
        this.keyRings = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.keyRings, (PGPPublicKeyRing)new PGPPublicKeyRing(CollectionSupport.singletonList((Object)key)));
        this.saveStoreInternal();
    }

    @Nonnull
    public static Signature signatureOf(@Nonnull InputStream stream) throws IOException {
        return new Signature(stream);
    }

    public boolean contains(@Nonnull Signature signature) {
        PGPSignature sig = signature.getSignature();
        this.log.debug("Looking for key with Id {}", (Object)signature);
        return this.keyRings.getPublicKey(sig.getKeyID()) != null;
    }

    public boolean checkSignature(@Nonnull InputStream input, @Nonnull Signature signature) throws IOException {
        try {
            PGPSignature pgpSignature = signature.getSignature();
            PGPPublicKey pubKey = this.keyRings.getPublicKey(pgpSignature.getKeyID());
            pgpSignature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
            byte[] buffer = new byte[1024];
            int count = input.read(buffer);
            while (count > 0) {
                pgpSignature.update(buffer, 0, count);
                count = input.read(buffer);
            }
            boolean result = pgpSignature.verify();
            if (result) {
                this.log.debug("Signature Check Succeeded");
            } else {
                this.log.debug("Signature Check Failed");
            }
            return result;
        }
        catch (PGPException e) {
            this.log.warn("Error thrown during signature check", (Throwable)e);
            return false;
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.explicitTrustStore != null) {
            this.store = InstallerSupport.pathOf(this.explicitTrustStore);
            if (!Files.exists(this.store, new LinkOption[0])) {
                this.log.error("Trust store {} does not exist", (Object)this.explicitTrustStore);
                throw new ComponentInitializationException("Supplied trust store does not exist.");
            }
            this.backup = InstallerSupport.pathOf(this.explicitTrustStore + ".backup");
            this.log.debug("Loading explicit truststore {}", (Object)this.explicitTrustStore);
            try {
                this.loadStore();
            }
            catch (IOException e) {
                this.log.error("Could not load explicit trust store {}", (Object)this.explicitTrustStore, (Object)e);
                throw new ComponentInitializationException((Exception)e);
            }
        }
        if (this.pluginId == null) {
            throw new ComponentInitializationException("Plugin Id not set up");
        }
        if (this.idpHome == null) {
            throw new ComponentInitializationException("IdP home not set up");
        }
        if (!Files.exists(this.idpHome, new LinkOption[0])) {
            throw new ComponentInitializationException("IdP home '" + String.valueOf(this.idpHome) + "' does not exist");
        }
        try {
            Path parent = this.idpHome.resolve("credentials").resolve(this.pluginId);
            if (!Files.exists(parent, new LinkOption[0])) {
                this.log.info("Plugin {}: Trust store folder does not exist, creating", (Object)this.pluginId);
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            this.store = parent.resolve("truststore.asc");
            this.backup = parent.resolve("truststore.asc.backup");
            if (!Files.exists(this.store, new LinkOption[0])) {
                this.log.info("Plugin {}: Trust store does not exist, creating", (Object)this.pluginId);
                this.createNewStore();
            } else {
                this.log.debug("Plugin {}: Trust store exists, loading", (Object)this.pluginId);
                this.loadStore();
            }
        }
        catch (IOException e) {
            throw new ComponentInitializationException((Exception)e);
        }
    }

    public static final class Signature {
        @Nonnull
        private PGPSignature signature;
        @Nonnull
        private String keyId;

        protected Signature(@Nonnull InputStream input) throws IOException {
            block9: {
                try (InputStream sigStream = PGPUtil.getDecoderStream((InputStream)input);){
                    JcaPGPObjectFactory factory = new JcaPGPObjectFactory(sigStream);
                    Object first = factory.nextObject();
                    if (first != null && first instanceof PGPSignatureList) {
                        PGPSignatureList list = (PGPSignatureList)first;
                        if (list.isEmpty()) {
                            throw new IOException("Provided signature file was empty");
                        }
                        this.signature = (PGPSignature)Constraint.isNotNull((Object)list.get(0), (String)"PGPSignatureList#get(0) retiurned null for non empty list");
                        break block9;
                    }
                    throw new IOException("Provided file was not a signature");
                }
            }
            String kid = String.format("0x%X", this.signature.getKeyID());
            assert (kid != null);
            this.keyId = kid;
        }

        @Nonnull
        protected PGPSignature getSignature() {
            return this.signature;
        }

        @Nonnull
        public String toString() {
            return this.keyId;
        }
    }
}

