/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.binding.message.DefaultMessageResolver;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.style.ToStringCreator;

public class MessageBuilder {
    private Object source;
    private Set<String> codes = new LinkedHashSet<String>();
    private Severity severity;
    private List<Object> args = new ArrayList<Object>();
    private String defaultText;

    public MessageBuilder info() {
        this.severity = Severity.INFO;
        return this;
    }

    public MessageBuilder warning() {
        this.severity = Severity.WARNING;
        return this;
    }

    public MessageBuilder error() {
        this.severity = Severity.ERROR;
        return this;
    }

    public MessageBuilder fatal() {
        this.severity = Severity.FATAL;
        return this;
    }

    public MessageBuilder source(Object source) {
        this.source = source;
        return this;
    }

    public MessageBuilder code(String code) {
        this.codes.add(code);
        return this;
    }

    public MessageBuilder codes(String ... codes) {
        if (codes == null) {
            return this;
        }
        this.codes.addAll(Arrays.asList(codes));
        return this;
    }

    public MessageBuilder arg(Object arg) {
        this.args.add(arg);
        return this;
    }

    public MessageBuilder args(Object ... args) {
        if (args == null) {
            return this;
        }
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public MessageBuilder resolvableArg(Object arg) {
        this.args.add(new ResolvableArgument(arg));
        return this;
    }

    public MessageBuilder resolvableArgs(Object ... args) {
        if (args == null) {
            return this;
        }
        for (Object arg : args) {
            this.args.add(new ResolvableArgument(arg));
        }
        return this;
    }

    public MessageBuilder defaultText(String text) {
        this.defaultText = text;
        return this;
    }

    public MessageResolver build() {
        if (this.severity == null) {
            this.severity = Severity.INFO;
        }
        if (this.codes == null && this.defaultText == null) {
            throw new IllegalArgumentException("A message code or the message text is required to build this message resolver");
        }
        String[] codesArray = this.codes.toArray(new String[this.codes.size()]);
        Object[] argsArray = this.args.toArray(new Object[this.args.size()]);
        return new DefaultMessageResolver(this.source, codesArray, this.severity, argsArray, this.defaultText);
    }

    private static class ResolvableArgument
    implements MessageSourceResolvable {
        private Object arg;

        public ResolvableArgument(Object arg) {
            this.arg = arg;
        }

        public Object[] getArguments() {
            return null;
        }

        public String[] getCodes() {
            return new String[]{this.arg.toString()};
        }

        public String getDefaultMessage() {
            return this.arg.toString();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("arg", this.arg).toString();
        }
    }
}

