/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.proxy.impl;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.FailedLoginException;
import net.shibboleth.idp.cas.protocol.ProtocolContext;
import net.shibboleth.idp.cas.proxy.ProxyValidator;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.service.ServiceContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.slf4j.Logger;

public class HttpClientProxyValidator
implements ProxyValidator {
    @Nonnull
    @NotEmpty
    protected static final String HTTPS_SCHEME = "https";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpClientProxyValidator.class);
    @Nonnull
    private final Function<ProfileRequestContext, ServiceContext> serviceCtxLookupFunction = new ChildContextLookup(ServiceContext.class).compose((Function)new ChildContextLookup(ProtocolContext.class));
    @Nonnull
    private final HttpClient httpClient;
    @Nonnull
    private final HttpClientSecurityParameters securityParameters;
    @NotEmpty
    private Set<Integer> allowedResponseCodes;

    public HttpClientProxyValidator(@Nonnull HttpClient client, @Nonnull HttpClientSecurityParameters parameters) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP client cannot be null");
        this.securityParameters = (HttpClientSecurityParameters)Constraint.isNotNull((Object)parameters, (String)"HTTP client security parameters cannot be null");
        this.allowedResponseCodes = CollectionSupport.singleton((Object)200);
    }

    public void setAllowedResponseCodes(@Nonnull @NotEmpty Set<Integer> responseCodes) {
        Constraint.isNotEmpty(responseCodes, (String)"Response codes cannot be null or empty.");
        this.allowedResponseCodes = CollectionSupport.copyToSet(responseCodes);
    }

    public void validate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull URI proxyCallbackUri) throws GeneralSecurityException {
        Constraint.isNotNull((Object)proxyCallbackUri, (String)"Proxy callback URI cannot be null");
        if (!HTTPS_SCHEME.equalsIgnoreCase(proxyCallbackUri.getScheme())) {
            throw new GeneralSecurityException(String.valueOf(proxyCallbackUri) + " is not an https URI as required.");
        }
        ServiceContext serviceContext = this.serviceCtxLookupFunction.apply(profileRequestContext);
        if (serviceContext == null) {
            throw new IllegalStateException("Service context not found in profile request context as required");
        }
        int status = this.connect(proxyCallbackUri, serviceContext.getService());
        if (!this.allowedResponseCodes.contains(status)) {
            throw new FailedLoginException(String.valueOf(proxyCallbackUri) + " returned unacceptable HTTP status code: " + status);
        }
    }

    protected int connect(@Nonnull URI uri, @Nonnull Service service) throws GeneralSecurityException {
        int n;
        block15: {
            HttpClientContext clientContext = HttpClientContext.create();
            assert (clientContext != null);
            HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.securityParameters, (boolean)true);
            HttpClientProxyValidator.setCASTLSTrustEngineCriteria(clientContext, uri, service);
            this.log.debug("Attempting to validate CAS proxy callback URI {}", (Object)uri);
            HttpGet request = new HttpGet(uri);
            assert (request != null);
            ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)request, (HttpContext)clientContext);
            try {
                String scheme = request.getScheme();
                assert (scheme != null);
                HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
                n = response.getCode();
                if (response == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClientProtocolException e) {
                    throw new GeneralSecurityException("HTTP protocol error", e);
                }
                catch (SSLPeerUnverifiedException e) {
                    throw new CredentialException("Untrusted certificate presented by CAS proxy callback endpoint");
                }
                catch (SSLException e) {
                    if (e.getCause() instanceof CertificateException) {
                        throw (CertificateException)e.getCause();
                    }
                    throw new GeneralSecurityException("SSL connection error", e);
                }
                catch (IOException e) {
                    throw new GeneralSecurityException("IO error", e);
                }
            }
            response.close();
        }
        return n;
    }

    private static void setCASTLSTrustEngineCriteria(@Nonnull HttpClientContext context, @Nonnull URI requestUri, @Nonnull Service service) {
        EntityDescriptor entityDescriptor = service.getEntityDescriptor();
        String entityID = entityDescriptor != null ? entityDescriptor.getEntityID() : service.getName();
        assert (entityID != null);
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("https://www.apereo.org/cas/protocol"), new UsageCriterion(UsageType.SIGNING), new TrustedNamesCriterion(CollectionSupport.singleton((Object)requestUri.getHost()))});
        context.setAttribute("opensaml.CriteriaSet", (Object)criteria);
    }
}

