/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute.transcoding.impl;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.cas.attribute.AbstractCASAttributeTranscoder;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CASDateTimeAttributeTranscoder
extends AbstractCASAttributeTranscoder<DateTimeAttributeValue> {
    @Nonnull
    @NotEmpty
    public static final String PROP_EPOCH_UNITS = "cas.epochUnits";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CASDateTimeAttributeTranscoder.class);

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        return value instanceof DateTimeAttributeValue;
    }

    @Nullable
    protected String encodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule, @Nonnull DateTimeAttributeValue value) throws AttributeEncodingException {
        return DOMTypeSupport.instantToString((Instant)value.getValue());
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nullable String value) {
        Instant retVal;
        if (value != null && (retVal = this.getDateTimeValue(rule, value)) != null) {
            return new DateTimeAttributeValue(retVal);
        }
        return null;
    }

    @Nullable
    protected Instant getDateTimeValue(@Nonnull TranscodingRule rule, @Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            Long longVal = Long.valueOf(value);
            if (longVal != null) {
                return this.getDateTimeValue(rule, longVal);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            return DOMTypeSupport.stringToInstant((String)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.warn("{} rule unable to process string value as numeric or ISO format", rule.getOrDefault("id", String.class, (Object)"(none)"));
            return null;
        }
    }

    @Nullable
    protected Instant getDateTimeValue(@Nonnull TranscodingRule rule, @Nonnull Long value) {
        String units = (String)rule.getOrDefault(PROP_EPOCH_UNITS, String.class, (Object)"s");
        if ("s".equals(units)) {
            return Instant.ofEpochSecond(value);
        }
        if ("ms".equals(units)) {
            return Instant.ofEpochMilli(value);
        }
        this.log.error("{} rule property {} must be 's' or 'ms'", rule.getOrDefault("id", String.class, (Object)"(none)"), (Object)PROP_EPOCH_UNITS);
        return null;
    }
}

