/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import com.google.common.base.MoreObjects;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProxyAuthenticationPrincipal
implements Principal,
Predicate<ProfileRequestContext> {
    @Nonnull
    private Collection<String> authorities;
    @Nonnull
    private Set<String> audiences;
    @Nullable
    private Integer proxyCount;

    public ProxyAuthenticationPrincipal() {
        this.authorities = new ArrayList<String>();
        this.audiences = new HashSet<String>();
    }

    public ProxyAuthenticationPrincipal(@Nonnull Collection<String> proxiedAuthorities) {
        Constraint.isNotNull(proxiedAuthorities, (String)"Proxied authority collection cannot be null");
        this.authorities = new ArrayList<String>(List.copyOf(proxiedAuthorities));
        this.audiences = new HashSet<String>();
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName() {
        String result = this.authorities.toString();
        assert (result != null);
        return result;
    }

    @Nonnull
    @Live
    public Collection<String> getAuthorities() {
        return this.authorities;
    }

    @Nonnull
    @Live
    public Set<String> getAudiences() {
        return this.audiences;
    }

    @Nullable
    @NonNegative
    public Integer getProxyCount() {
        return this.proxyCount;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            this.proxyCount = Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count cannot be negative");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx;
        RelyingPartyContext relyingPartyContext = rpCtx = input != null ? (RelyingPartyContext)input.getSubcontext(RelyingPartyContext.class) : null;
        if (rpCtx == null) {
            return true;
        }
        ProfileConfiguration pc = rpCtx.getProfileConfig();
        if (!(pc instanceof AuthenticationProfileConfiguration)) {
            return true;
        }
        if (((AuthenticationProfileConfiguration)pc).isLocal()) {
            return true;
        }
        if (this.proxyCount != null && this.proxyCount == 0) {
            return false;
        }
        return rpCtx.getRelyingPartyId() == null || this.audiences.isEmpty() || this.audiences.contains(rpCtx.getRelyingPartyId());
    }

    @Override
    public int hashCode() {
        return this.authorities.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ProxyAuthenticationPrincipal) {
            return this.authorities.equals(((ProxyAuthenticationPrincipal)other).getAuthorities()) && Objects.equals(this.proxyCount, ((ProxyAuthenticationPrincipal)other).getProxyCount()) && this.audiences.equals(((ProxyAuthenticationPrincipal)other).getAudiences());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authorities", this.authorities).add("proxyCount", (Object)this.proxyCount).add("audiences", this.audiences).toString();
    }
}

