/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal;

import java.security.Principal;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;

public final class PrincipalSupport {
    private PrincipalSupport() {
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static Set<String> getPrincipalNames(@Nonnull Subject subject, @Nonnull Class<? extends Principal> claz) {
        return (Set)((NonnullSupplier)subject.getPrincipals(claz).stream().map(Principal::getName).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableSet()))).get();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static Set<String> getPrincipalNames(@Nonnull AuthenticationResult result, @Nonnull Class<? extends Principal> claz) {
        return PrincipalSupport.getPrincipalNames(result.getSubject(), claz);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static Set<String> getPrincipalNames(@Nonnull AuthenticationContext authenticationContext, @Nonnull String flowId, @Nonnull Class<? extends Principal> claz) {
        AuthenticationResult result = authenticationContext.getActiveResults().get(flowId);
        return result != null ? PrincipalSupport.getPrincipalNames(result.getSubject(), claz) : CollectionSupport.emptySet();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static Set<String> getPrincipalNames(@Nonnull MultiFactorAuthenticationContext mfaContext, @Nonnull String flowId, @Nonnull Class<? extends Principal> claz) {
        AuthenticationResult result = mfaContext.getActiveResults().get(flowId);
        return result != null ? PrincipalSupport.getPrincipalNames(result.getSubject(), claz) : CollectionSupport.emptySet();
    }
}

