/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.cryptacular.CryptUtil;
import org.cryptacular.CryptoException;
import org.cryptacular.SaltedHash;
import org.cryptacular.StreamException;
import org.cryptacular.io.Resource;
import org.cryptacular.util.ByteUtil;

public final class HashUtil {
    private HashUtil() {
    }

    public static byte[] hash(Digest digest, Object ... data) throws CryptoException, StreamException {
        CryptUtil.assertNotNullArg(digest, "Digest cannot be null");
        CryptUtil.assertNotNullArg(data, "Data cannot be null");
        for (Object o : data) {
            byte[] bytes;
            if (o instanceof byte[]) {
                bytes = (byte[])o;
                digest.update(bytes, 0, bytes.length);
                continue;
            }
            if (o instanceof CharSequence) {
                bytes = ByteUtil.toBytes((CharSequence)o);
                digest.update(bytes, 0, bytes.length);
                continue;
            }
            if (o instanceof InputStream) {
                HashUtil.hashStream(digest, (InputStream)o);
                continue;
            }
            if (o instanceof Resource) {
                InputStream in;
                try {
                    in = ((Resource)o).getInputStream();
                }
                catch (IOException e) {
                    throw new StreamException(e);
                }
                HashUtil.hashStream(digest, in);
                continue;
            }
            throw new IllegalArgumentException("Invalid input data type " + o);
        }
        byte[] output = new byte[digest.getDigestSize()];
        try {
            digest.doFinal(output, 0);
        }
        catch (RuntimeException e) {
            throw new CryptoException("Hash computation error", e);
        }
        return output;
    }

    public static byte[] hash(Digest digest, int iterations, Object ... data) throws CryptoException, StreamException {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be positive");
        }
        byte[] output = HashUtil.hash(digest, data);
        try {
            for (int i = 1; i < iterations; ++i) {
                digest.update(output, 0, output.length);
                digest.doFinal(output, 0);
            }
        }
        catch (RuntimeException e) {
            throw new CryptoException("Hash computation error", e);
        }
        return output;
    }

    public static boolean compareHash(Digest digest, byte[] hash, int iterations, Object ... data) throws CryptoException, StreamException {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be positive");
        }
        CryptUtil.assertNotNullArg(digest, "Digest cannot be null");
        CryptUtil.assertNotNullArg(hash, "Hash cannot be null");
        CryptUtil.assertNotNullArg(data, "Data cannot be null");
        if (hash.length > digest.getDigestSize()) {
            byte[] hashPart = Arrays.copyOfRange(hash, 0, digest.getDigestSize());
            byte[] saltPart = Arrays.copyOfRange(hash, digest.getDigestSize(), hash.length);
            Object[] dataWithSalt = Arrays.copyOf(data, data.length + 1);
            dataWithSalt[data.length] = saltPart;
            return Arrays.equals(HashUtil.hash(digest, iterations, dataWithSalt), hashPart);
        }
        return Arrays.equals(HashUtil.hash(digest, iterations, data), hash);
    }

    public static boolean compareHash(Digest digest, SaltedHash hash, int iterations, boolean saltAfterData, Object ... data) throws CryptoException, StreamException {
        Object[] dataWithSalt;
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be positive");
        }
        CryptUtil.assertNotNullArg(digest, "Digest cannot be null");
        CryptUtil.assertNotNullArg(hash, "Hash cannot be null");
        CryptUtil.assertNotNullArg(data, "Data cannot be null");
        if (saltAfterData) {
            dataWithSalt = Arrays.copyOf(data, data.length + 1);
            dataWithSalt[data.length] = hash.getSalt();
        } else {
            dataWithSalt = new Object[data.length + 1];
            dataWithSalt[0] = hash.getSalt();
            System.arraycopy(data, 0, dataWithSalt, 1, data.length);
        }
        return Arrays.equals(HashUtil.hash(digest, iterations, dataWithSalt), hash.getHash());
    }

    public static byte[] sha1(Object ... data) {
        return HashUtil.hash((Digest)new SHA1Digest(), data);
    }

    public static byte[] sha256(Object ... data) {
        return HashUtil.hash((Digest)new SHA256Digest(), data);
    }

    public static byte[] sha512(Object ... data) {
        return HashUtil.hash((Digest)new SHA512Digest(), data);
    }

    public static byte[] sha3(int bitLength, Object ... data) {
        return HashUtil.hash((Digest)new SHA3Digest(bitLength), data);
    }

    private static void hashStream(Digest digest, InputStream in) {
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = in.read(buffer)) > 0) {
                digest.update(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }
}

