/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.pem;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.bouncycastle.util.io.pem.PemHeader;
import org.cryptacular.CryptUtil;
import org.cryptacular.pem.Descriptor;
import org.cryptacular.pem.Format;
import org.cryptacular.pem.PemObject;
import org.cryptacular.util.ByteUtil;
import org.cryptacular.util.CodecUtil;

final class PemParser {
    PemParser() {
    }

    PemObject parse(byte[] encoded) {
        try {
            return this.parse(new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(encoded), ByteUtil.ASCII_CHARSET)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not parse PEM data", e);
        }
    }

    private PemObject parse(BufferedReader reader) throws IOException {
        return PemParser.parseInternal(reader, PemParser.parseDescriptor(CryptUtil.assertNotNullArg(reader, "Reader cannot be null")));
    }

    private static PemObject parseInternal(BufferedReader reader, Descriptor descriptor) throws IOException {
        String line;
        CryptUtil.assertNotNullArg(reader, "Reader cannot be null");
        CryptUtil.assertNotNullArg(descriptor, "Descriptor cannot be null");
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>();
        int lineLength = -1;
        String endMarker = (descriptor.getFormat() == Format.RFC4716 ? "---- END" : "-----END") + " " + descriptor.getType();
        String beginMarker = (descriptor.getFormat() == Format.RFC4716 ? "---- BEGIN" : "-----BEGIN") + " " + descriptor.getType();
        String beginLine = reader.readLine();
        if (beginLine == null || !beginLine.startsWith(beginMarker)) {
            throw new IllegalArgumentException(String.format("%s not found in \"%s", beginMarker, beginLine));
        }
        StringBuilder base64DataBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            PemHeader headerLine = PemParser.parseHeader(reader, line, descriptor.getFormat());
            if (headerLine != null) {
                headers.add(headerLine);
                continue;
            }
            lineLength = Math.max(lineLength, line.length());
            if (line.contains(endMarker)) break;
            base64DataBuilder.append(line.trim());
        }
        String b64buffer = base64DataBuilder.toString();
        if (line == null) {
            throw new IllegalArgumentException(endMarker + " not found");
        }
        PemParser.assertLineLength(descriptor.getFormat(), lineLength);
        if (descriptor.getFormat().equals((Object)Format.RFC7468)) {
            return new PemObject(descriptor, CodecUtil.b64(b64buffer));
        }
        return new PemObject(descriptor, headers, CodecUtil.b64(b64buffer));
    }

    private static PemHeader parseHeader(BufferedReader reader, String line, Format format) throws IOException {
        if (line.contains(":")) {
            int index = line.indexOf(58);
            String specifier = line.substring(0, index);
            String value = line.substring(index + 1);
            if (format == Format.RFC4716) {
                while (value.charAt(value.length() - 1) == '\\') {
                    value = value.substring(0, value.length() - 1);
                    String l = reader.readLine();
                    if (l != null) {
                        value = value + l;
                        continue;
                    }
                    break;
                }
            } else if (format == Format.RFC1421) {
                String l;
                if (specifier.startsWith("X-")) {
                    specifier = specifier.substring(2);
                }
                StringBuilder sb = new StringBuilder(value);
                String nextLine = PemParser.peekNextLine(reader, 64);
                while (nextLine != null && nextLine.startsWith(" ") && (l = reader.readLine()) != null) {
                    sb.append(l.trim());
                    nextLine = PemParser.peekNextLine(reader, 64);
                }
                value = sb.toString();
            }
            if ((value = value.trim()).length() >= 2 && value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return new PemHeader(specifier, value);
        }
        return null;
    }

    private static void assertLineLength(Format format, int maxLineLength) throws IllegalArgumentException {
        switch (format) {
            case RFC4716: {
                if (maxLineLength <= 72) break;
                throw new IllegalArgumentException("Malformed RFC 4716 type PEM data (b64 lines longer than maximum allowed length)");
            }
            case RFC7468: {
                if (maxLineLength <= 64) break;
                throw new IllegalArgumentException("Malformed RFC 7468 type PEM data (b64 lines longer than maximum allowed length)");
            }
            case RFC1421: {
                if (maxLineLength <= 64) break;
                throw new IllegalArgumentException("Malformed RFC 1421 type PEM data (b64 lines longer than maximum allowed length)");
            }
        }
    }

    private static Descriptor parseDescriptor(BufferedReader reader) throws IOException {
        boolean isRFC4716Markers;
        String pemType;
        String explanatoryText = PemParser.readExplanatoryText(reader);
        String firstPemLine = PemParser.peekNextLine(reader, 76);
        if (firstPemLine != null && (pemType = PemParser.getPemType(isRFC4716Markers = firstPemLine.startsWith("---- BEGIN"), firstPemLine)) != null) {
            Format format = PemParser.getFormat(explanatoryText, pemType, isRFC4716Markers);
            return new Descriptor(format, explanatoryText, pemType);
        }
        return null;
    }

    private static Format getFormat(String explanatoryText, String pemType, boolean isRFC4716Markers) {
        Format format = !explanatoryText.isEmpty() ? Format.RFC7468 : (pemType.startsWith("PGP") ? Format.RFC2440 : (isRFC4716Markers ? Format.RFC4716 : Format.RFC1421));
        return format;
    }

    private static String getPemType(boolean isRFC4716Markers, String firstPemLine) {
        if (isRFC4716Markers) {
            int index = firstPemLine.indexOf("----", "---- BEGIN".length());
            if ("---- BEGIN".length() <= index && index <= firstPemLine.length()) {
                return firstPemLine.substring("---- BEGIN".length(), index).trim();
            }
        } else {
            int index = firstPemLine.indexOf("-----", "-----BEGIN".length());
            if ("-----BEGIN".length() <= index && index <= firstPemLine.length()) {
                return firstPemLine.substring("-----BEGIN".length(), index).trim();
            }
        }
        return null;
    }

    private static String readExplanatoryText(BufferedReader reader) throws IOException {
        StringBuilder explanatoryTextBuilder = new StringBuilder(0);
        String line = PemParser.peekNextLine(reader, 76);
        while (line != null && !line.startsWith("-----BEGIN") && !line.startsWith("---- BEGIN")) {
            line = reader.readLine();
            if (line != null && !line.isEmpty()) {
                explanatoryTextBuilder.append(line).append("\n");
            }
            line = PemParser.peekNextLine(reader, 76);
        }
        return explanatoryTextBuilder.toString();
    }

    private static String peekNextLine(BufferedReader reader, int maximumReadLength) throws IOException {
        reader.mark(maximumReadLength);
        String nextLine = reader.readLine();
        reader.reset();
        return nextLine;
    }
}

