/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.pem;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Constants {
    public static final int RFC7468_MAX_LINE_LENGTH = 64;
    public static final int RFC1421_MAX_LINE_LENGTH = 64;
    public static final int RFC4716_MAX_LINE_LENGTH = 72;
    public static final int RFC2440_MAX_LINE_LENGTH = 76;
    public static final String RFC4716_SPECIFIER_PRIVATE_BEGIN_MARKER = "x-";
    public static final String RFC1421_ENCAPSULATION_MARKER = "-----";
    public static final String RFC4716_ENCAPSULATION_MARKER = "----";
    public static final String RFC4716_ENCAPSULATION_BEGIN_MARKER = "---- BEGIN";
    public static final String RFC4716_ENCAPSULATION_END_MARKER = "---- END";
    public static final String RFC1421_ENCAPSULATION_BEGIN_MARKER = "-----BEGIN";
    public static final String RFC1421_ENCAPSULATION_END_MARKER = "-----END";
    private static final String RFC1421_SPECIFIER_PROC_TYPE = "Proc-Type";
    private static final String RFC1421_SPECIFIER_DEK_INFO = "DEK-Info";
    private static final String RFC1421_SPECIFIER_ORIGINATOR_ID_ASYMMETRIC = "Originator-ID-Asymmetric";
    private static final String RFC1421_SPECIFIER_ORIGINATOR_ID_SYMMETRIC = "Originator-ID-Symmetric";
    private static final String RFC1421_SPECIFIER_RECIPIENT_ID_ASYMMETRIC = "Recipient-ID-Asymmetric";
    private static final String RFC1421_SPECIFIER_RECIPIENT_ID_SYMMETRIC = "Recipient-ID-Symmetric";
    private static final String RFC1421_SPECIFIER_ORIGINATOR_CERTIFICATE = "Originator-Certificate";
    private static final String RFC1421_SPECIFIER_ISSUER_CERTIFICATE = "Issuer-Certificate";
    private static final String RFC1421_SPECIFIER_MIC_INFO = "MIC-Info";
    private static final String RFC1421_SPECIFIER_KEY_INFO = "Key-Info";
    private static final String RFC1421_SPECIFIER_CRL = "CRL";
    private static final String RFC2440_SPECIFIER_VERSION = "Version";
    private static final String RFC2440_SPECIFIER_COMMENT = "Comment";
    private static final String RFC2440_SPECIFIER_MESSAGE_ID = "MessageID";
    private static final String RFC2440_SPECIFIER_HASH = "Hash";
    private static final String RFC2440_SPECIFIER_CHARSET = "Charset";
    private static final String RFC4716_SPECIFIER_SUBJECT = "Subject";
    private static final String RFC4716_SPECIFIER_COMMENT = "Comment";
    public static final String RFC1421_HEADER_FIELD_DEK_INFO = "DEK-Info:";
    public static final String RFC1421_HEADER_FIELD_PROC_TYPE = "Proc-Type:";
    public static final Set<String> RFC4716_SPECIFIERS = Collections.unmodifiableSet(Stream.of("Subject", "Comment").collect(Collectors.toSet()));
    public static final Set<String> RFC2440_SPECIFIERS = Collections.unmodifiableSet(Stream.of("Charset", "Hash", "MessageID", "Comment", "Version").collect(Collectors.toSet()));
    public static final Set<String> RFC1421_SPECIFIERS = Collections.unmodifiableSet(Stream.of("CRL", "Key-Info", "MIC-Info", "Issuer-Certificate", "Originator-Certificate", "Recipient-ID-Symmetric", "Recipient-ID-Asymmetric", "Originator-ID-Symmetric", "Originator-ID-Asymmetric", "DEK-Info", "Proc-Type").collect(Collectors.toSet()));

    private Constants() {
    }
}

