/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.security.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.security.KeyAuthoritySupport;
import net.shibboleth.idp.saml.xmlobject.KeyAuthority;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.collection.LockableClassToInstanceMultiMap;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.TrustedNamesCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.slf4j.Logger;

public class MetadataPKIXValidationInformationResolver
extends AbstractInitializableComponent
implements PKIXValidationInformationResolver {
    public static final int KEY_AUTHORITY_VERIFY_DEPTH_DEFAULT = 1;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataPKIXValidationInformationResolver.class);
    @Nonnull
    private RoleDescriptorResolver roleDescriptorResolver;

    public MetadataPKIXValidationInformationResolver(@Nonnull @ParameterName(name="resolver") RoleDescriptorResolver resolver) {
        this.roleDescriptorResolver = (RoleDescriptorResolver)Constraint.isNotNull((Object)resolver, (String)"RoleDescriptor resolver cannot be null");
    }

    @Nonnull
    public RoleDescriptorResolver getRoleDescriptorResolver() {
        return this.roleDescriptorResolver;
    }

    @Nullable
    public PKIXValidationInformation resolveSingle(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        Iterator<PKIXValidationInformation> pkixInfoIter = this.resolve(criteriaSet).iterator();
        if (pkixInfoIter.hasNext()) {
            return pkixInfoIter.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<PKIXValidationInformation> resolve(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        this.checkComponentActive();
        if (criteriaSet == null) {
            throw new ResolverException("CriteriaSet was null");
        }
        this.checkCriteriaRequirements(criteriaSet);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class);
        assert (entityIdCriterion != null);
        String entityID = entityIdCriterion.getEntityId();
        EntityRoleCriterion roleCriteria = (EntityRoleCriterion)criteriaSet.get(EntityRoleCriterion.class);
        assert (roleCriteria != null);
        QName role = roleCriteria.getRole();
        String protocol = null;
        ProtocolCriterion protocolCriteria = (ProtocolCriterion)criteriaSet.get(ProtocolCriterion.class);
        if (protocolCriteria != null) {
            protocol = protocolCriteria.getProtocol();
        }
        return this.retrievePKIXInfoFromMetadata(criteriaSet, entityID, role, protocol);
    }

    @Nonnull
    public Set<String> resolveTrustedNames(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        this.checkComponentActive();
        if (criteriaSet == null) {
            throw new ResolverException("CriteriaSet was null");
        }
        this.checkCriteriaRequirements(criteriaSet);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class);
        assert (entityIdCriterion != null);
        String entityID = entityIdCriterion.getEntityId();
        EntityRoleCriterion roleCriteria = (EntityRoleCriterion)criteriaSet.get(EntityRoleCriterion.class);
        assert (roleCriteria != null);
        QName role = roleCriteria.getRole();
        String protocol = null;
        ProtocolCriterion protocolCriteria = (ProtocolCriterion)criteriaSet.get(ProtocolCriterion.class);
        if (protocolCriteria != null) {
            protocol = protocolCriteria.getProtocol();
        }
        UsageCriterion usageCriteria = (UsageCriterion)criteriaSet.get(UsageCriterion.class);
        UsageType usage = null;
        usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        HashSet<String> trustedNames = new HashSet<String>();
        trustedNames.addAll(this.retrieveTrustedNamesFromMetadata(criteriaSet, entityID, role, protocol, usage));
        trustedNames.add(entityID);
        TrustedNamesCriterion trustedNamesCriterion = (TrustedNamesCriterion)criteriaSet.get(TrustedNamesCriterion.class);
        if (trustedNamesCriterion != null) {
            trustedNames.addAll(trustedNamesCriterion.getTrustedNames());
        }
        return trustedNames;
    }

    public boolean supportsTrustedNameResolution() {
        return true;
    }

    protected void checkCriteriaRequirements(@Nonnull CriteriaSet criteriaSet) {
        EntityIdCriterion entityCriteria = (EntityIdCriterion)Constraint.isNotNull((Object)((EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class)), (String)"EntityIdCriterion must be supplied");
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)entityCriteria.getEntityId()), (String)"Credential owner entity ID criteria value must be supplied");
        EntityRoleCriterion roleCriteria = (EntityRoleCriterion)Constraint.isNotNull((Object)((EntityRoleCriterion)criteriaSet.get(EntityRoleCriterion.class)), (String)"EntityRoleCriterion must be supplied");
        Constraint.isNotNull((Object)roleCriteria.getRole(), (String)"Credential entity role criteria value must be supplied");
    }

    @Nonnull
    protected Collection<PKIXValidationInformation> retrievePKIXInfoFromMetadata(@Nullable CriteriaSet criteriaSet, @Nonnull String entityID, @Nonnull QName role, @Nullable String protocol) throws ResolverException {
        this.log.debug("Attempting to retrieve PKIX validation info from resolver for entity: {}", (Object)entityID);
        LinkedHashSet<PKIXValidationInformation> accumulator = new LinkedHashSet<PKIXValidationInformation>();
        Iterable<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(criteriaSet, entityID, role, protocol);
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            assert (roleDescriptor != null);
            this.resolvePKIXInfo(accumulator, roleDescriptor);
        }
        return accumulator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolvePKIXInfo(@Nonnull Collection<PKIXValidationInformation> accumulator, @Nonnull RoleDescriptor roleDescriptor) throws ResolverException {
        XMLObject parent = roleDescriptor.getParent();
        if (parent instanceof EntityDescriptor) {
            EntityDescriptor entityDescriptor = (EntityDescriptor)parent;
            this.resolvePKIXInfo(accumulator, entityDescriptor.getExtensions());
            LockableClassToInstanceMultiMap entityDescriptorObjectMetadata = entityDescriptor.getObjectMetadata();
            ReadWriteLock rwlock = entityDescriptorObjectMetadata.getReadWriteLock();
            try {
                rwlock.readLock().lock();
                accumulator.addAll(entityDescriptorObjectMetadata.get(PKIXValidationInformation.class));
            }
            finally {
                rwlock.readLock().unlock();
            }
        }
    }

    protected void resolvePKIXInfo(@Nonnull Collection<PKIXValidationInformation> accumulator, @Nullable Extensions extensions) throws ResolverException {
        if (extensions == null) {
            return;
        }
        List authorities = extensions.getUnknownXMLObjects(KeyAuthority.DEFAULT_ELEMENT_NAME);
        if (authorities == null || authorities.isEmpty()) {
            return;
        }
        for (XMLObject xmlObj : authorities) {
            assert (xmlObj != null);
            this.extractPKIXInfo(accumulator, (KeyAuthority)xmlObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractPKIXInfo(@Nonnull Collection<PKIXValidationInformation> accumulator, @Nonnull KeyAuthority keyAuthority) throws ResolverException {
        List cachedPKIXInfo;
        LockableClassToInstanceMultiMap keyAuthorityObjectMetadata = keyAuthority.getObjectMetadata();
        ReadWriteLock rwlock = keyAuthorityObjectMetadata.getReadWriteLock();
        try {
            rwlock.readLock().lock();
            cachedPKIXInfo = keyAuthorityObjectMetadata.get(PKIXValidationInformation.class);
            if (!cachedPKIXInfo.isEmpty()) {
                this.log.debug("Resolved cached PKIXValidationInformation from KeyAuthority object metadata");
                accumulator.addAll(cachedPKIXInfo);
                return;
            }
            this.log.debug("Found no cached PKIXValidationInformation in KeyAuthority object metadata, resolving XML");
        }
        finally {
            rwlock.readLock().unlock();
        }
        try {
            rwlock.writeLock().lock();
            cachedPKIXInfo = keyAuthorityObjectMetadata.get(PKIXValidationInformation.class);
            if (!cachedPKIXInfo.isEmpty()) {
                this.log.debug("PKIXValidationInformation was resolved and cached by another thread while this thread was waiting on the write lock");
                accumulator.addAll(cachedPKIXInfo);
                return;
            }
            PKIXValidationInformation pkixInfo = KeyAuthoritySupport.extractPKIXValidationInfo((KeyAuthority)keyAuthority);
            if (pkixInfo != null) {
                keyAuthorityObjectMetadata.put((Object)pkixInfo);
                accumulator.add(pkixInfo);
            }
        }
        catch (SecurityException e) {
            throw new ResolverException("Error resolving PKIXValidationInformation for shibmd:KeyAuthority", (Exception)((Object)e));
        }
        finally {
            rwlock.writeLock().unlock();
        }
    }

    @Nonnull
    @Live
    protected Set<String> retrieveTrustedNamesFromMetadata(@Nullable CriteriaSet criteriaSet, @Nonnull String entityID, @Nonnull QName role, @Nullable String protocol, @Nonnull UsageType usage) throws ResolverException {
        this.log.debug("Attempting to retrieve trusted names for PKIX validation from resolver for entity: {}", (Object)entityID);
        HashSet<String> trustedNames = new HashSet<String>();
        Iterable<RoleDescriptor> roleDescriptors = this.getRoleDescriptors(criteriaSet, entityID, role, protocol);
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            List keyDescriptors = roleDescriptor.getKeyDescriptors();
            for (KeyDescriptor keyDescriptor : keyDescriptors) {
                KeyInfo keyInfo;
                UsageType mdUsage = keyDescriptor.getUse();
                if (mdUsage == null) {
                    mdUsage = UsageType.UNSPECIFIED;
                }
                if (!this.matchUsage(mdUsage, usage) || (keyInfo = keyDescriptor.getKeyInfo()) == null) continue;
                this.getTrustedNames(trustedNames, keyInfo);
            }
        }
        return trustedNames;
    }

    protected void getTrustedNames(@Nonnull Set<String> accumulator, @Nonnull KeyInfo keyInfo) {
        accumulator.addAll(KeyInfoSupport.getKeyNames((KeyInfo)keyInfo));
    }

    protected boolean matchUsage(@Nonnull UsageType metadataUsage, @Nonnull UsageType criteriaUsage) {
        if (metadataUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return metadataUsage == criteriaUsage;
    }

    @Nonnull
    protected Iterable<RoleDescriptor> getRoleDescriptors(@Nullable CriteriaSet criteriaSet, @Nonnull String entityID, @Nonnull QName role, @Nullable String protocol) throws ResolverException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrieving role descriptor metadata for entity '{}' in role '{}' for protocol '{}'", new Object[]{entityID, role, protocol});
            }
            return this.getRoleDescriptorResolver().resolve((Object)criteriaSet);
        }
        catch (ResolverException e) {
            this.log.error("Unable to resolve information from metadata: {}", (Object)e.getMessage());
            throw new ResolverException("Unable to resolve unformation from metadata", (Exception)((Object)e));
        }
    }
}

