/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableServiceGaugeSet;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.saml.metadata.resolver.BatchMetadataResolver;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.RemoteMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.slf4j.Logger;

public class MetadataResolverServiceGaugeSet
extends ReloadableServiceGaugeSet<MetadataResolver>
implements MetricSet,
MetricFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MetadataResolverServiceGaugeSet.class);

    public MetadataResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"update"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastUpdate() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastUpdate());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"refresh"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastRefresh() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastRefresh());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"successfulRefresh"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((RefreshableMetadataResolver)resolver).getLastSuccessfulRefresh());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"error"}), new Gauge<Map<String, String>>(){

            public Map<String, String> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, String>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, String> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof RefreshableMetadataResolver && ((RefreshableMetadataResolver)resolver).getLastFailureCause() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)MetadataResolverServiceGaugeSet.this.extractErrorMessage(((RefreshableMetadataResolver)resolver).getLastFailureCause()));
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"rootValidUntil"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Instant>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Instant> mapBuilder, MetadataResolver resolver) {
                        if (resolver instanceof BatchMetadataResolver && ((BatchMetadataResolver)resolver).getRootValidUntil() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)((BatchMetadataResolver)resolver).getRootValidUntil());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"type"}), new Gauge<Map<String, String>>(){

            public Map<String, String> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, String>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, String> mapBuilder, MetadataResolver resolver) {
                        if (resolver.getType() != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)resolver.getType());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"uri"}), new Gauge<Map<String, String>>(){

            public Map<String, String> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, String>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, String> mapBuilder, MetadataResolver resolver) {
                        RemoteMetadataResolver remote;
                        String uri;
                        if (resolver instanceof RemoteMetadataResolver && (uri = (remote = (RemoteMetadataResolver)resolver).getMetadataURI()) != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)remote.getMetadataURI());
                        }
                    }
                });
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"filters"}), new Gauge<Map<String, Collection<String>>>(){

            public Map<String, Collection<String>> getValue() {
                return MetadataResolverServiceGaugeSet.this.valueGetter(new BiConsumer<ImmutableMap.Builder<String, Collection<String>>, MetadataResolver>(){

                    @Override
                    public void accept(ImmutableMap.Builder<String, Collection<String>> mapBuilder, MetadataResolver resolver) {
                        String type;
                        MetadataFilter filter = resolver.getMetadataFilter();
                        if (filter instanceof MetadataFilterChain) {
                            MetadataFilterChain chaining = (MetadataFilterChain)filter;
                            mapBuilder.put((Object)resolver.getId(), (Object)chaining.getFilters().stream().map(MetadataFilter::getType).filter((Predicate<String>)Predicates.notNull()).collect(Collectors.toUnmodifiableList()));
                        } else if (filter != null && (type = filter.getType()) != null) {
                            mapBuilder.put((Object)resolver.getId(), (Object)CollectionSupport.singletonList((Object)type));
                        }
                    }
                });
            }
        });
    }

    @Nonnull
    private String extractErrorMessage(Throwable t) {
        Throwable source = null;
        source = ResolverException.class.isInstance(t) && t.getCause() != null ? t.getCause() : t;
        if (source.getMessage() != null) {
            return source.getClass().getName() + ": " + source.getMessage();
        }
        for (Throwable cause = source.getCause(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null) continue;
            return cause.getClass().getName() + ": " + cause.getMessage();
        }
        return source.getClass().getName() + ": <Detailed error message not specified>";
    }

    @Nonnull
    private <T> Map<String, T> valueGetter(@Nonnull BiConsumer<ImmutableMap.Builder<String, T>, MetadataResolver> consume) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        try (ServiceableComponent component = this.getService().getServiceableComponent();){
            if (!(component.getComponent() instanceof MetadataResolver)) {
                this.log.warn("{} : Injected Service was not for an Metadata Resolver : ({}) ", (Object)this.getLogPrefix(), component.getComponent().getClass());
            } else {
                for (MetadataResolver resolver : this.getMetadataResolvers((MetadataResolver)component.getComponent())) {
                    consume.accept(mapBuilder, resolver);
                }
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return mapBuilder.build();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try (ServiceableComponent component = this.getService().getServiceableComponent();){
            if (component.getComponent() instanceof MetadataResolver) {
                return;
            }
            this.log.error("{} : Injected service was not for a MetadataResolver ({}) ", (Object)this.getLogPrefix(), component.getClass());
            throw new ComponentInitializationException("Injected service was not for a MetadataResolver");
        }
        catch (ServiceException e) {
            this.log.debug("{} : Injected service has not initialized sucessfully yet. Skipping type test", (Object)this.getLogPrefix(), (Object)e);
            return;
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    private List<MetadataResolver> getAllChildren(@Nonnull ChainingMetadataResolver parent) {
        ArrayList<MetadataResolver> result = new ArrayList<MetadataResolver>(parent.getResolvers().size());
        for (MetadataResolver child : parent.getResolvers()) {
            if (child instanceof ChainingMetadataResolver) {
                result.addAll(this.getAllChildren((ChainingMetadataResolver)child));
                continue;
            }
            result.add(child);
        }
        return CollectionSupport.copyToList(result);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    private Iterable<MetadataResolver> getMetadataResolvers(@Nonnull MetadataResolver rootResolver) {
        if (rootResolver instanceof ChainingMetadataResolver) {
            return this.getAllChildren((ChainingMetadataResolver)rootResolver);
        }
        return CollectionSupport.singletonList((Object)rootResolver);
    }
}

