/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.AbstractMetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.metadata.resolver.filter.impl.ByReferenceMetadataFilter;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ByReferenceMetadataFilterBridge
extends AbstractMetadataFilter
implements ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ByReferenceMetadataFilterBridge.class);
    private boolean enabled = true;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private MetadataFilterChain filterChain;

    public void setEnabled(boolean flag) {
        this.enabled = flag;
    }

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.applicationContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        if (!this.enabled) {
            return metadata;
        }
        MetadataFilterChain chain = null;
        ByReferenceMetadataFilterBridge byReferenceMetadataFilterBridge = this;
        synchronized (byReferenceMetadataFilterBridge) {
            if (this.filterChain != null) {
                chain = this.filterChain;
            } else if (this.applicationContext != null) {
                try {
                    Map beans = this.applicationContext.getBeansOfType(ByReferenceMetadataFilter.class);
                    this.log.debug("Bridging to {} ByReference filters in Spring context", (Object)beans.size());
                    this.filterChain = chain = new MetadataFilterChain();
                    Collection vals = beans.values();
                    assert (vals != null);
                    chain.setFilters(CollectionSupport.copyToList(vals));
                }
                catch (BeansException e) {
                    throw new FilterException((Exception)((Object)e));
                }
            } else {
                throw new FilterException("ApplicationContext is not set");
            }
        }
        return chain.filter(metadata, context);
    }
}

