/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class GSSAcceptorLoginModule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GSSAcceptorLoginModule.class);
    @Nullable
    private LoginModule krbModule;
    @Nonnull
    private Map<String, String> state = new HashMap<String, String>();
    @Nonnull
    private Map<String, String> options = new HashMap<String, String>();
    @Nonnull
    private KerberosRealmSettings realm;

    public GSSAcceptorLoginModule(@Nonnull KerberosRealmSettings realmSettings, boolean refreshKrb5Config, @Nonnull @NotEmpty String loginModuleClassName) {
        this.realm = (KerberosRealmSettings)((Object)Constraint.isNotNull((Object)((Object)realmSettings), (String)"KerberosRealmSettings cannot be null"));
        this.options.put("refreshKrb5Config", Boolean.valueOf(refreshKrb5Config).toString());
        this.options.put("useKeyTab", "true");
        this.options.put("keyTab", realmSettings.getKeytab());
        this.options.put("principal", realmSettings.getServicePrincipal());
        this.options.put("isInitiator", realmSettings.getPassword() != null ? "true" : "false");
        this.options.put("storeKey", "true");
        try {
            this.krbModule = (LoginModule)Class.forName(loginModuleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.log.error("Unable to instantiate JAAS module for Kerberos", (Throwable)e);
            this.krbModule = null;
        }
    }

    public Subject login() throws LoginException {
        LoginModule module = this.krbModule;
        if (module == null) {
            throw new LoginException("No JAAS module for Kerberos available");
        }
        UsernamePasswordCallbackHandler callbackH = new UsernamePasswordCallbackHandler(this.realm.getServicePrincipal(), this.realm.getPassword());
        Subject subject = new Subject();
        module.initialize(subject, callbackH, this.state, this.options);
        if (module.login()) {
            module.commit();
        }
        return subject;
    }

    public void logout() throws LoginException {
        LoginModule module = this.krbModule;
        if (module != null) {
            module.logout();
        }
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        @Nullable
        private String name;
        @Nullable
        private String password;

        public UsernamePasswordCallbackHandler(@Nullable String theName, String thePassword) {
            this.name = theName;
            this.password = thePassword;
        }

        @Override
        public void handle(@Nullable Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks != null && callbacks.length > 0) {
                String nm = this.name;
                if (nm == null || nm.length() == 0) {
                    throw new IllegalArgumentException("No username provided");
                }
                String pwd = this.password;
                if (pwd == null || pwd.length() == 0) {
                    throw new IllegalArgumentException("No password provided");
                }
                for (Callback c : callbacks) {
                    if (c instanceof NameCallback) {
                        ((NameCallback)c).setName(nm);
                        continue;
                    }
                    if (c instanceof PasswordCallback) {
                        ((PasswordCallback)c).setPassword(pwd.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(c);
                }
            }
        }
    }
}

