/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.EncryptedCookieManager;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateCredentials
extends AbstractAuditingValidationAction
implements CredentialValidator.WarningHandler,
CredentialValidator.ErrorHandler {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateCredentials.class);
    @Nonnull
    private List<CredentialValidator> credentialValidators;
    private boolean requireAll;
    @Nullable
    private AccountLockoutManager lockoutManager;
    @Nonnull
    private Collection<Subject> results;
    @Nullable
    private CredentialValidator currentValidator;
    private boolean warningSignaled;
    private boolean errorSignaled;

    public ValidateCredentials() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.credentialValidators = CollectionSupport.emptyList();
        this.results = new ArrayList<Subject>(1);
    }

    public void setLockoutManager(@Nullable AccountLockoutManager manager) {
        this.checkSetterPreconditions();
        this.lockoutManager = manager;
    }

    public void setValidators(@Nullable List<CredentialValidator> validators) {
        this.checkSetterPreconditions();
        this.credentialValidators = validators != null ? CollectionSupport.copyToList(validators) : CollectionSupport.emptyList();
    }

    public void setRequireAll(boolean flag) {
        this.checkSetterPreconditions();
        this.requireAll = flag;
    }

    @Nonnull
    @NotEmpty
    public String getMetricName() {
        assert (this.currentValidator != null);
        String cvId = this.currentValidator.getId();
        return super.getMetricName() + "." + cvId;
    }

    public void handleWarning(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        this.warningSignaled = true;
        super.handleWarning(profileRequestContext, authenticationContext, message, eventId);
    }

    public void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable String message, @Nonnull @NotEmpty String eventId) {
        this.errorSignaled = true;
        super.handleError(profileRequestContext, authenticationContext, message, eventId);
    }

    public void handleError(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull Exception e, @Nonnull @NotEmpty String eventId) {
        this.errorSignaled = true;
        super.handleError(profileRequestContext, authenticationContext, e, eventId);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.lockoutManager != null && this.lockoutManager.check(profileRequestContext)) {
            this.log.info("{} Account locked out, aborting authentication", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "AccountLocked", "AccountLocked");
            return;
        }
        for (CredentialValidator validator : this.credentialValidators) {
            this.log.trace("{} Attempting credential validation via {}", (Object)this.getLogPrefix(), (Object)validator.getId());
            this.currentValidator = validator;
            try {
                Subject subject = this.currentValidator.validate(profileRequestContext, authenticationContext, (CredentialValidator.WarningHandler)this, (CredentialValidator.ErrorHandler)this);
                if (subject == null) continue;
                this.results.add(subject);
                if (this.requireAll) continue;
                this.recordSuccess(profileRequestContext);
                this.buildAuthenticationResult(profileRequestContext, authenticationContext);
                if (!this.warningSignaled) {
                    ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
                }
                return;
            }
            catch (Exception e) {
                if (this.requireAll || !this.errorSignaled) {
                    super.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
                    this.errorSignaled = true;
                }
                this.recordFailure(profileRequestContext);
                if (!this.requireAll) continue;
                break;
            }
        }
        if (this.requireAll && !this.errorSignaled && !this.results.isEmpty()) {
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            if (!this.warningSignaled) {
                ActionSupport.buildProceedEvent((ProfileRequestContext)profileRequestContext);
            }
            return;
        }
        if (this.errorSignaled) {
            if (this.lockoutManager != null) {
                this.lockoutManager.increment(profileRequestContext);
            }
        } else {
            this.log.warn("{} No validators were available or usable", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "RequestUnsupported", "RequestUnsupported");
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        for (Subject s : this.results) {
            subject.getPrincipals().addAll(s.getPrincipals());
            subject.getPublicCredentials().addAll(s.getPublicCredentials());
            subject.getPrivateCredentials().addAll(s.getPrivateCredentials());
        }
        return subject;
    }

    @Override
    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.lockoutManager != null && !this.lockoutManager.clear(profileRequestContext)) {
            this.log.warn("{} Failed to clear lockout state", (Object)this.getLogPrefix());
        }
        super.recordSuccess(profileRequestContext);
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.currentValidator != null);
        return CollectionSupport.singletonMap((Object)"CV", (Object)this.currentValidator.getId());
    }

    public static class UsernamePasswordCleanupHook
    implements Consumer<ProfileRequestContext> {
        @Nullable
        private EncryptedCookieManager cookieManager;

        public void setEncryptedCookieManager(@Nullable EncryptedCookieManager manager) {
            this.cookieManager = manager;
        }

        @Override
        public void accept(@Nullable ProfileRequestContext input) {
            AuthenticationContext authnCtx;
            AuthenticationContext authenticationContext = authnCtx = input != null ? (AuthenticationContext)input.getSubcontext(AuthenticationContext.class) : null;
            if (authnCtx == null) {
                return;
            }
            UsernamePasswordContext upCtx = (UsernamePasswordContext)authnCtx.getSubcontext(UsernamePasswordContext.class);
            if (upCtx == null) {
                return;
            }
            if (authnCtx.isResultCacheable()) {
                String username = upCtx.getUsername();
                if (this.cookieManager != null && username != null) {
                    this.cookieManager.writeCookie(username);
                }
            } else if (this.cookieManager != null) {
                this.cookieManager.clearCookie();
            }
            upCtx.setPassword(null);
            authnCtx.removeSubcontext((BaseContext)upCtx);
        }
    }
}

