/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class SimpleSubjectCanonicalization
extends AbstractSubjectCanonicalizer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleSubjectCanonicalization.class);

    @Nullable
    public String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        UsernamePrincipal usernamePrincipal = this.getUsernamePrincipal(c14nContext);
        if (usernamePrincipal == null) {
            return null;
        }
        c14nContext.setPrincipalName(this.applyTransforms(usernamePrincipal.getName()));
        return "proceed";
    }

    @Nullable
    private UsernamePrincipal getUsernamePrincipal(@Nonnull SubjectCanonicalizationContext c14nContext) {
        Subject subject = c14nContext.getSubject();
        if (subject != null) {
            Set<UsernamePrincipal> prins = subject.getPrincipals(UsernamePrincipal.class);
            if (prins == null || prins.isEmpty()) {
                this.log.debug("{} No UsernamePrincipals were found", (Object)this.getLogPrefix());
            } else if (prins.size() > 1) {
                this.log.debug("{} Multiple UsernamePrincipals were found", (Object)this.getLogPrefix());
            } else {
                return prins.iterator().next();
            }
        }
        return null;
    }
}

