/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.script.ScriptContext;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.filter.FilterScriptContextExtender;
import net.shibboleth.idp.attribute.resolver.scripted.ResolverScriptContextExtender;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SubjectScriptContextExtender
extends AbstractInitializableComponent
implements ResolverScriptContextExtender,
FilterScriptContextExtender {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubjectScriptContextExtender.class);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void extendContext(@Nonnull ScriptContext scriptContext) {
        this.checkComponentActive();
        ProfileRequestContext prc = (ProfileRequestContext)scriptContext.getAttribute("profileContext");
        SubjectContext sc = this.subjectContextLookupStrategy.apply(prc);
        if (null == sc) {
            this.log.debug("SubjectScriptContextExtender could not locate SubjectContext");
        } else {
            List subjects = sc.getSubjects();
            scriptContext.setAttribute("subjects", subjects.toArray(new Subject[subjects.size()]), 100);
        }
    }
}

