/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic.impl;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.logic.RelyingPartyIdPredicate;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class RelyingPartiesActivationConditionFactory
implements Function<Map<String, Object>, Predicate<ProfileRequestContext>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartiesActivationConditionFactory.class);

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> apply(@Nullable Map<String, Object> rule) {
        if (rule == null) {
            return null;
        }
        Object relyingParties = rule.get("relyingParties");
        if (relyingParties instanceof Collection) {
            return new RelyingPartyIdPredicate((Collection)relyingParties);
        }
        if (relyingParties instanceof String) {
            Collection parsed = StringSupport.normalizeStringCollection((Collection)StringSupport.stringToList((String)((String)relyingParties), (String)" "));
            return new RelyingPartyIdPredicate(parsed);
        }
        if (relyingParties != null) {
            this.log.error("{} property did not contain a Collection or String, ignored", (Object)"relyingParties");
        }
        return null;
    }
}

